"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteRulesetRuleModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeleteRulesetRuleModal = ({
  closeDeleteModal,
  onConfirm: onSuccessAction
}) => {
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const onSuccess = () => {
    setIsLoading(false);
    closeDeleteModal();
    if (onSuccessAction) {
      onSuccessAction();
    }
  };
  const deleteOperation = () => {
    setIsLoading(true);
    onSuccess();
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: _i18n.i18n.translate('xpack.queryRules.deleteRulesetRuleModal.title', {
      defaultMessage: 'Delete query rule?'
    }),
    titleProps: {
      id: modalTitleId
    },
    onCancel: closeDeleteModal,
    onConfirm: deleteOperation,
    cancelButtonText: _i18n.i18n.translate('xpack.queryRules.deleteRulesetRuleModal.cancelButton', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.queryRules.deleteRulesetRuleModal.confirmButton', {
      defaultMessage: 'Delete rule'
    }),
    buttonColor: "danger",
    isLoading: isLoading
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.queryRules.deleteRulesetRuleModal.description",
    defaultMessage: "Are you sure you want to delete this rule?"
  }))));
};
exports.DeleteRulesetRuleModal = DeleteRulesetRuleModal;