"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatSetupPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_query_indices = require("../../hooks/use_query_indices");
var _doc_links = require("../../../common/doc_links");
var _use_usage_tracker = require("../../hooks/use_usage_tracker");
var _constants = require("../../analytics/constants");
var _add_data_sources = require("./add_data_sources");
var _connect_llm_button = require("./connect_llm_button");
var _create_index_button = require("./create_index_button");
var _upload_file_button = require("../upload_file_button");
var _playground_body_section = require("../playground_body_section");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ChatSetupPage = () => {
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const {
    indices,
    isLoading: isIndicesLoading
  } = (0, _use_query_indices.useQueryIndices)();
  (0, _react.useEffect)(() => {
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.load(_constants.AnalyticsEvents.setupChatPageLoaded);
  }, [usageTracker]);
  return /*#__PURE__*/_react.default.createElement(_playground_body_section.PlaygroundBodySection, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "discuss",
    "data-test-subj": "setupPage",
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchPlayground.setupPage.title",
      defaultMessage: "Set up a chat experience"
    })),
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchPlayground.setupPage.description",
      defaultMessage: "Experiment with combining your Elasticsearch data with powerful large language models (LLMs) using Playground for retrieval augmented generation (RAG)."
    })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchPlayground.setupPage.descriptionLLM",
      defaultMessage: "Connect to your LLM provider and select your data sources to get started."
    }))),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center"
    }, isIndicesLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      style: {
        minWidth: 360
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
      textAlign: "left",
      titleSize: "xs",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.searchPlayground.setupPage.connectToLLM",
        defaultMessage: "Large Language Model (LLM)"
      }),
      description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.searchPlayground.setupPage.connectToLLMDescription",
        defaultMessage: "Select a model to integrate with your chat experience. You can also set up your own connection."
      }),
      footer: /*#__PURE__*/_react.default.createElement(_connect_llm_button.ConnectLLMButton, null)
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      style: {
        minWidth: 360
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
      textAlign: "left",
      titleSize: "xs",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.searchPlayground.setupPage.elasticsearchData",
        defaultMessage: "Elasticsearch Data"
      }),
      description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.searchPlayground.setupPage.elasticsearchDataDescription",
        defaultMessage: "Select your data sources to include as context or upload files to start."
      }),
      footer: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, indices.length ? /*#__PURE__*/_react.default.createElement(_add_data_sources.AddDataSources, null) : /*#__PURE__*/_react.default.createElement(_create_index_button.CreateIndexButton, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_upload_file_button.UploadFileButton, {
        isSetup: true
      })))
    })))),
    footer: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs"
    }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchPlayground.setupPage.learnMore",
      defaultMessage: "Want to learn more?"
    }))), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "searchPlaygroundChatSetupPageReadDocumentationLink",
      href: _doc_links.docLinks.chatPlayground,
      target: "_blank",
      external: true
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchPlayground.setupPage.documentationLink",
      defaultMessage: "Read documentation"
    })))
  }));
};
exports.ChatSetupPage = ChatSetupPage;