"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PythonSemanticIngestDataExample = exports.PythonSearchExample = exports.PythonIngestDataExample = exports.PythonCreateIndexExamples = exports.PYTHON_INFO = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PYTHON_INFO = exports.PYTHON_INFO = {
  id: 'python',
  title: _i18n.i18n.translate('xpack.searchIndices.codingLanguages.python', {
    defaultMessage: 'Python'
  }),
  icon: 'python.svg',
  codeBlockLanguage: 'python'
};
const PYTHON_INSTALL_CMD = 'pip install elasticsearch';
const PythonCreateIndexExamples = exports.PythonCreateIndexExamples = {
  default: {
    installCommand: PYTHON_INSTALL_CMD,
    createIndex: ({
      elasticsearchURL,
      apiKey,
      indexName
    }) => `from elasticsearch import Elasticsearch

client = Elasticsearch(
  "${elasticsearchURL}",
  api_key="${apiKey !== null && apiKey !== void 0 ? apiKey : _constants.API_KEY_PLACEHOLDER}"
)

client.indices.create(
  index="${indexName !== null && indexName !== void 0 ? indexName : _constants.INDEX_PLACEHOLDER}",
  mappings={
        "properties": {
            "text": {"type": "text"}
        }
    }
)`
  },
  dense_vector: {
    installCommand: PYTHON_INSTALL_CMD,
    createIndex: ({
      elasticsearchURL,
      apiKey,
      indexName
    }) => `from elasticsearch import Elasticsearch

client = Elasticsearch(
    "${elasticsearchURL}",
    api_key="${apiKey !== null && apiKey !== void 0 ? apiKey : _constants.API_KEY_PLACEHOLDER}"
)

client.indices.create(
    index="${indexName !== null && indexName !== void 0 ? indexName : _constants.INDEX_PLACEHOLDER}",
    mappings={
        "properties": {
            "vector": {"type": "dense_vector", "dims": 3 },
            "text": {"type": "text"}
        }
    }
)`
  },
  semantic: {
    installCommand: PYTHON_INSTALL_CMD,
    createIndex: ({
      elasticsearchURL,
      apiKey,
      indexName
    }) => `from elasticsearch import Elasticsearch

client = Elasticsearch(
  "${elasticsearchURL}",
  api_key="${apiKey !== null && apiKey !== void 0 ? apiKey : _constants.API_KEY_PLACEHOLDER}"
)

client.indices.create(
  index="${indexName !== null && indexName !== void 0 ? indexName : _constants.INDEX_PLACEHOLDER}",
  mappings={
        "properties": {
            "text": {"type": "semantic_text"}
        }
    }
)`
  }
};
const ingestionCommand = ({
  elasticsearchURL,
  apiKey,
  indexName,
  sampleDocuments
}) => `from elasticsearch import Elasticsearch, helpers

client = Elasticsearch(
    "${elasticsearchURL}",
    api_key="${apiKey !== null && apiKey !== void 0 ? apiKey : _constants.API_KEY_PLACEHOLDER}"
)

index_name = "${indexName}"

docs = ${JSON.stringify(sampleDocuments, null, 4)}

bulk_response = helpers.bulk(client, docs, index=index_name)
print(bulk_response)`;
const updateMappingsCommand = ({
  elasticsearchURL,
  apiKey,
  indexName,
  mappingProperties
}) => `from elasticsearch import Elasticsearch

client = Elasticsearch(
    "${elasticsearchURL}",
    api_key="${apiKey !== null && apiKey !== void 0 ? apiKey : _constants.API_KEY_PLACEHOLDER}"
)

index_name = "${indexName}"

mappings = ${JSON.stringify({
  properties: mappingProperties
}, null, 4)}

mapping_response = client.indices.put_mapping(index=index_name, body=mappings)
print(mapping_response)
`;
const semanticIngestCommand = ({
  elasticsearchURL,
  apiKey,
  indexName,
  sampleDocuments
}) => `from elasticsearch import Elasticsearch, helpers

client = Elasticsearch(
    "${elasticsearchURL}",
    api_key="${apiKey !== null && apiKey !== void 0 ? apiKey : _constants.API_KEY_PLACEHOLDER}",
)

index_name = "${indexName}"

docs = ${JSON.stringify(sampleDocuments, null, 4)}

# Timeout to allow machine learning model loading and semantic ingestion to complete
ingestion_timeout=300

bulk_response = helpers.bulk(
    client.options(request_timeout=ingestion_timeout),
    docs,
    index=index_name
)
print(bulk_response)`;
const PythonIngestDataExample = exports.PythonIngestDataExample = {
  installCommand: PYTHON_INSTALL_CMD,
  ingestCommand: ingestionCommand,
  updateMappingsCommand
};
const searchCommand = ({
  elasticsearchURL,
  apiKey,
  indexName,
  queryObject
}) => `from elasticsearch import Elasticsearch

client = Elasticsearch(
    "${elasticsearchURL}",
    api_key="${apiKey !== null && apiKey !== void 0 ? apiKey : _constants.API_KEY_PLACEHOLDER}"
)

retriever_object = ${JSON.stringify(queryObject.retriever, null, 4)}

search_response = client.search(
    index="${indexName}",
    retriever=retriever_object,
)
print(search_response['hits']['hits'])
`;
const PythonSearchExample = exports.PythonSearchExample = {
  searchCommand
};
const PythonSemanticIngestDataExample = exports.PythonSemanticIngestDataExample = {
  ...PythonIngestDataExample,
  ingestCommand: semanticIngestCommand
};