"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PlatinumLicensePopover = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const PlatinumLicensePopover = ({
  button,
  isPopoverOpen,
  closePopover,
  stackManagementHref,
  subscriptionLink
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, _i18n.i18n.translate('searchConnectors.connectors.upgradeTitle', {
    defaultMessage: 'Upgrade to Elastic Platinum'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false,
    size: "s",
    css: (0, _react2.css)`
          max-width: calc(${euiTheme.size.xl} * 10);
        `
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('searchConnectors.connectors.upgradeDescription', {
    defaultMessage: 'To use this connector, you must update your license to Platinum or start a 30-day free trial.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, subscriptionLink && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "popout",
    target: "_blank",
    href: subscriptionLink
  }, _i18n.i18n.translate('searchConnectors.connectors.subscriptionLabel', {
    defaultMessage: 'Subscription plans'
  }))), stackManagementHref && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "wrench",
    iconSide: "right",
    href: stackManagementHref
  }, _i18n.i18n.translate('searchConnectors.manageLicenseButtonLabel', {
    defaultMessage: 'Manage license'
  }))))));
};
exports.PlatinumLicensePopover = PlatinumLicensePopover;