"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDefaultTimezone = void 0;
var _public = require("@kbn/kibana-react-plugin/public");
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDefaultTimezone = () => {
  const kibanaTz = (0, _public.useUiSetting)('dateFormat:tz');
  if (!kibanaTz || kibanaTz === 'Browser') {
    var _moment$tz$guess, _moment$tz;
    return {
      defaultTimezone: (_moment$tz$guess = (_moment$tz = _moment.default.tz) === null || _moment$tz === void 0 ? void 0 : _moment$tz.guess()) !== null && _moment$tz$guess !== void 0 ? _moment$tz$guess : 'UTC',
      isBrowser: true
    };
  }
  return {
    defaultTimezone: kibanaTz,
    isBrowser: false
  };
};
exports.useDefaultTimezone = useDefaultTimezone;