"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteDataView = DeleteDataView;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _use_profiling_dependencies = require("../../components/contexts/profiling_dependencies/use_profiling_dependencies");
var _profiling_app_page_template = require("../../components/profiling_app_page_template");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DeleteDataView() {
  const {
    start: {
      core: {
        docLinks
      }
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  return /*#__PURE__*/_react.default.createElement(_profiling_app_page_template.ProfilingAppPageTemplate, {
    tabs: [],
    restrictWidth: true,
    hideSearchBar: true
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: 'flex',
      flexGrow: 1,
      justifyContent: 'center',
      alignItems: 'center'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    style: {
      flexGrow: 0,
      maxWidth: '500px'
    },
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "danger",
      size: "xxl",
      type: "warning"
    }),
    title: "You have existing profiling data",
    description: "To proceed with the Universal Profiling setup, please delete existing profiling data following the steps described in the link below.",
    footer: /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "profilingDeleteDataViewDeleteExistingProfilingDataLink",
      href: `${docLinks.ELASTIC_WEBSITE_URL}/guide/en/observability/${docLinks.DOC_LINK_VERSION}/profiling-upgrade.html#profiling-delete-data`,
      target: "_blank"
    }, "Delete existing profiling data"))
  })));
}