"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openCustomizePanelFlyout = void 0;
var _public = require("@kbn/kibana-react-plugin/public");
var _presentationContainers = require("@kbn/presentation-containers");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _react = _interopRequireDefault(require("react"));
var _kibana_services = require("../../kibana_services");
var _customize_panel_editor = require("./customize_panel_editor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const openCustomizePanelFlyout = ({
  focusOnTitle,
  api
}) => {
  // send the overlay ref to the parent if it is capable of tracking overlays
  const parent = api.parentApi;
  const overlayTracker = (0, _presentationContainers.tracksOverlays)(parent) ? parent : undefined;
  const {
    Provider: KibanaReactContextProvider
  } = (0, _public.createKibanaReactContext)({
    uiSettings: _kibana_services.core.uiSettings
  });
  const handle = _kibana_services.core.overlays.openFlyout((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(KibanaReactContextProvider, null, /*#__PURE__*/_react.default.createElement(_customize_panel_editor.CustomizePanelEditor, {
    focusOnTitle: focusOnTitle,
    api: api,
    onClose: () => {
      if (overlayTracker) overlayTracker.clearOverlays();
      handle.close();
    }
  })), _kibana_services.core), {
    size: 's',
    'data-test-subj': 'customizePanel',
    onClose: overlayRef => {
      if (overlayTracker) overlayTracker.clearOverlays();
      overlayRef.close();
    },
    maxWidth: true
  });
  overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.openOverlay(handle);
};
exports.openCustomizePanelFlyout = openCustomizePanelFlyout;