"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.viewInAppUrlActionVariableDescription = exports.valueActionVariableDescription = exports.timestampActionVariableDescription = exports.tagsActionVariableDescription = exports.reasonActionVariableDescription = exports.orchestratorActionVariableDescription = exports.labelsActionVariableDescription = exports.hostActionVariableDescription = exports.groupingObjectActionVariableDescription = exports.groupActionVariableDescription = exports.containerActionVariableDescription = exports.cloudActionVariableDescription = exports.alertDetailUrlActionVariableDescription = exports.SUM_I18N = exports.RATE_I18N = exports.PERCENTILE_99_I18N = exports.PERCENTILE_95_I18N = exports.MIN_I18N = exports.MAX_I18N = exports.LAST_VALUE_I18N = exports.DOCUMENT_COUNT_I18N = exports.CUSTOM_EQUATION_I18N = exports.CARDINALITY_I18N = exports.AVERAGE_I18N = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DOCUMENT_COUNT_I18N = exports.DOCUMENT_COUNT_I18N = _i18n.i18n.translate('xpack.observability.customThreshold.rule.aggregators.documentCount', {
  defaultMessage: 'Document count'
});
const AVERAGE_I18N = metric => _i18n.i18n.translate('xpack.observability.customThreshold.rule.aggregators.average', {
  defaultMessage: 'Average {metric}',
  values: {
    metric
  }
});
exports.AVERAGE_I18N = AVERAGE_I18N;
const PERCENTILE_99_I18N = metric => _i18n.i18n.translate('xpack.observability.customThreshold.rule.aggregators.p99', {
  defaultMessage: '99th percentile of {metric}',
  values: {
    metric
  }
});
exports.PERCENTILE_99_I18N = PERCENTILE_99_I18N;
const PERCENTILE_95_I18N = metric => _i18n.i18n.translate('xpack.observability.customThreshold.rule.aggregators.p95', {
  defaultMessage: '95th percentile of {metric}',
  values: {
    metric
  }
});
exports.PERCENTILE_95_I18N = PERCENTILE_95_I18N;
const RATE_I18N = metric => _i18n.i18n.translate('xpack.observability.customThreshold.rule.aggregators.rate', {
  defaultMessage: 'Rate of {metric}',
  values: {
    metric
  }
});
exports.RATE_I18N = RATE_I18N;
const MAX_I18N = metric => _i18n.i18n.translate('xpack.observability.customThreshold.rule.aggregators.max', {
  defaultMessage: 'Max {metric}',
  values: {
    metric
  }
});
exports.MAX_I18N = MAX_I18N;
const MIN_I18N = metric => _i18n.i18n.translate('xpack.observability.customThreshold.rule.aggregators.min', {
  defaultMessage: 'Min {metric}',
  values: {
    metric
  }
});
exports.MIN_I18N = MIN_I18N;
const CARDINALITY_I18N = metric => _i18n.i18n.translate('xpack.observability.customThreshold.rule.aggregators.cardinality', {
  defaultMessage: 'Cardinality of the {metric}',
  values: {
    metric
  }
});
exports.CARDINALITY_I18N = CARDINALITY_I18N;
const SUM_I18N = metric => _i18n.i18n.translate('xpack.observability.customThreshold.rule.aggregators.sum', {
  defaultMessage: 'Sum of the {metric}',
  values: {
    metric
  }
});
exports.SUM_I18N = SUM_I18N;
const LAST_VALUE_I18N = metric => _i18n.i18n.translate('xpack.observability.customThreshold.rule.aggregators.last_value', {
  defaultMessage: 'Last value of {metric}',
  values: {
    metric
  }
});
exports.LAST_VALUE_I18N = LAST_VALUE_I18N;
const CUSTOM_EQUATION_I18N = exports.CUSTOM_EQUATION_I18N = _i18n.i18n.translate('xpack.observability.customThreshold.rule.aggregators.customEquation', {
  defaultMessage: 'Custom equation'
});

// Action variable descriptions

const groupActionVariableDescription = exports.groupActionVariableDescription = _i18n.i18n.translate('xpack.observability.customThreshold.rule.groupActionVariableDescription', {
  defaultMessage: 'The array of objects containing groups that are reporting data'
});
const groupingObjectActionVariableDescription = exports.groupingObjectActionVariableDescription = _i18n.i18n.translate('xpack.observability.customThreshold.rule.groupingObjectActionVariableDescription', {
  defaultMessage: 'The object containing groups that are reporting data'
});
const alertDetailUrlActionVariableDescription = exports.alertDetailUrlActionVariableDescription = _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertDetailUrlActionVariableDescription', {
  defaultMessage: 'Link to the alert troubleshooting view for further context and details. This will be an empty string if the server.publicBaseUrl is not configured.'
});
const reasonActionVariableDescription = exports.reasonActionVariableDescription = _i18n.i18n.translate('xpack.observability.customThreshold.rule.reasonActionVariableDescription', {
  defaultMessage: 'A concise description of the reason for the alert'
});
const timestampActionVariableDescription = exports.timestampActionVariableDescription = _i18n.i18n.translate('xpack.observability.customThreshold.rule.timestampDescription', {
  defaultMessage: 'A timestamp of when the alert was detected.'
});
const valueActionVariableDescription = exports.valueActionVariableDescription = _i18n.i18n.translate('xpack.observability.customThreshold.rule.valueActionVariableDescription', {
  defaultMessage: 'List of the condition values.'
});
const viewInAppUrlActionVariableDescription = exports.viewInAppUrlActionVariableDescription = _i18n.i18n.translate('xpack.observability.customThreshold.rule.viewInAppUrlActionVariableDescription', {
  defaultMessage: 'Link to the alert source'
});
const cloudActionVariableDescription = exports.cloudActionVariableDescription = _i18n.i18n.translate('xpack.observability.customThreshold.rule.cloudActionVariableDescription', {
  defaultMessage: 'The cloud object defined by ECS if available in the source.'
});
const hostActionVariableDescription = exports.hostActionVariableDescription = _i18n.i18n.translate('xpack.observability.customThreshold.rule.hostActionVariableDescription', {
  defaultMessage: 'The host object defined by ECS if available in the source.'
});
const containerActionVariableDescription = exports.containerActionVariableDescription = _i18n.i18n.translate('xpack.observability.customThreshold.rule.containerActionVariableDescription', {
  defaultMessage: 'The container object defined by ECS if available in the source.'
});
const orchestratorActionVariableDescription = exports.orchestratorActionVariableDescription = _i18n.i18n.translate('xpack.observability.customThreshold.rule.orchestratorActionVariableDescription', {
  defaultMessage: 'The orchestrator object defined by ECS if available in the source.'
});
const labelsActionVariableDescription = exports.labelsActionVariableDescription = _i18n.i18n.translate('xpack.observability.customThreshold.rule.labelsActionVariableDescription', {
  defaultMessage: 'List of labels associated with the entity where this alert triggered.'
});
const tagsActionVariableDescription = exports.tagsActionVariableDescription = _i18n.i18n.translate('xpack.observability.customThreshold.rule.tagsActionVariableDescription', {
  defaultMessage: 'List of tags associated with the entity where this alert triggered.'
});