"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDeleteKnowledgeBaseEntry = useDeleteKnowledgeBaseEntry;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@kbn/react-query");
var _constants = require("../constants");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useDeleteKnowledgeBaseEntry() {
  const {
    observabilityAIAssistant,
    notifications: {
      toasts
    }
  } = (0, _use_kibana.useKibana)().services;
  const queryClient = (0, _reactQuery.useQueryClient)();
  const observabilityAIAssistantApi = observabilityAIAssistant.service.callApi;
  return (0, _reactQuery.useMutation)([_constants.REACT_QUERY_KEYS.CREATE_KB_ENTRIES], ({
    id: entryId
  }) => {
    return observabilityAIAssistantApi('DELETE /internal/observability_ai_assistant/kb/entries/{entryId}', {
      signal: null,
      params: {
        path: {
          entryId
        }
      }
    });
  }, {
    networkMode: 'always',
    onSuccess: (_data, {
      id,
      isUserInstruction
    }) => {
      if (isUserInstruction) {
        toasts.addSuccess(_i18n.i18n.translate('xpack.observabilityAiAssistantManagement.kb.deleteUserInstruction.successNotification', {
          defaultMessage: 'Successfully deleted user instruction'
        }));
      } else {
        toasts.addSuccess(_i18n.i18n.translate('xpack.observabilityAiAssistantManagement.kb.deleteManualEntry.successNotification', {
          defaultMessage: 'Successfully deleted {id}',
          values: {
            id
          }
        }));
        queryClient.invalidateQueries({
          queryKey: [_constants.REACT_QUERY_KEYS.GET_KB_ENTRIES],
          refetchType: 'all'
        });
      }
    },
    onError: (error, {
      id
    }) => {
      var _error$body$message, _error$body;
      toasts.addError(new Error((_error$body$message = (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : error.message), {
        title: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.kb.deleteManualEntry.errorNotification', {
          defaultMessage: 'Something went wrong while deleting {name}',
          values: {
            name: id
          }
        })
      });
    }
  });
}