"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchAlerts = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchAlerts = async ({
  alertTypeIds,
  filters,
  timeRange,
  clusterUuid,
  fetch
}) => {
  const url = `../api/monitoring/v1/alert/${clusterUuid}/status`;
  const response = await fetch(url, {
    method: 'POST',
    body: JSON.stringify({
      alertTypeIds,
      filters,
      timeRange
    })
  });
  return response;
};
exports.fetchAlerts = fetchAlerts;