"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditJob = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _mlValidators = require("@kbn/ml-validators");
var _custom_hooks = require("../../../../components/custom_hooks");
var _job_utils = require("../../../../../../common/util/job_utils");
var _components = require("../../common/components");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Edit job flyout for overriding job configuration.
 */
const EditJob = ({
  job,
  jobOverride,
  existingGroupIds,
  onClose
}) => {
  var _formState$jobGroups2;
  const [formState, setFormState] = (0, _custom_hooks.usePartialState)({
    jobGroups: jobOverride && jobOverride.groups || job.config.groups
  });
  const [validationResult, setValidationResult] = (0, _react.useState)({});
  const groupValidator = (0, _mlValidators.composeValidators)(value => (0, _job_utils.isJobIdValid)(value) ? null : {
    pattern: true
  }, (0, _mlValidators.maxLengthValidator)(_mlValidators.JOB_ID_MAX_LENGTH));
  const handleValidation = () => {
    var _formState$jobGroups;
    const jobGroupsValidationResult = ((_formState$jobGroups = formState.jobGroups) !== null && _formState$jobGroups !== void 0 ? _formState$jobGroups : []).map(group => groupValidator(group)).filter(result => result !== null);
    setValidationResult({
      jobGroups: jobGroupsValidationResult,
      formValid: jobGroupsValidationResult.length === 0
    });
  };
  (0, _react.useEffect)(() => {
    handleValidation();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [formState.jobGroups]);
  const onSave = () => {
    const result = {
      job_id: job.id,
      groups: formState.jobGroups
    };
    onClose(result);
  };
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: () => onClose(null),
    "aria-labelledby": flyoutTitleId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutTitleId
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.recognize.overrideConfigurationHeader",
    defaultMessage: "Override configuration for {jobID}",
    values: {
      jobID: job.id
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_components.JobGroupsInput, {
    existingGroups: existingGroupIds,
    selectedGroups: (_formState$jobGroups2 = formState.jobGroups) !== null && _formState$jobGroups2 !== void 0 ? _formState$jobGroups2 : [],
    onChange: value => {
      setFormState({
        jobGroups: value
      });
    },
    validation: {
      valid: !validationResult.jobGroups || validationResult.jobGroups.length === 0,
      message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.newJob.recognize.jobGroupAllowedCharactersDescription",
        defaultMessage: "Job group names can contain lowercase alphanumeric (a-z and 0-9), hyphens or underscores; must start and end with an alphanumeric character"
      })
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: () => onClose(null),
    flush: "left"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.recognize.cancelJobOverrideLabel",
    defaultMessage: "Close"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => onSave(),
    fill: true,
    disabled: !validationResult.formValid
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.recognize.saveJobOverrideLabel",
    defaultMessage: "Save"
  }))))));
};
exports.EditJob = EditJob;