"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PercentileAggField = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../common/constants");
var _elasticsearch_util = require("../../../../common/elasticsearch_util");
var _ordinal_suffix = require("../../util/ordinal_suffix");
var _agg_field = require("./agg_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class PercentileAggField extends _agg_field.AggField {
  constructor(params) {
    super({
      ...params,
      ...{
        aggType: _constants.AGG_TYPE.PERCENTILE
      }
    });
    (0, _defineProperty2.default)(this, "_percentile", void 0);
    this._percentile = params.percentile;
  }
  supportsFieldMetaFromEs() {
    return true;
  }
  supportsFieldMetaFromLocalData() {
    // Elasticsearch vector tile search API returns meta tiles for aggregation metrics
    return true;
  }
  getMbFieldName() {
    return this._source.isMvt() ? this.getName() + `.values.${this._percentile}${Number.isInteger(this._percentile) ? '.0' : ''}` : this.getName();
  }
  canValueBeFormatted() {
    return true;
  }
  async getLabel() {
    if (this._label) {
      return this._label;
    }
    if (this._percentile === 50) {
      const median = _i18n.i18n.translate('xpack.maps.fields.percentileMedianLabek', {
        defaultMessage: 'median'
      });
      return `${median} ${this.getRootName()}`;
    }
    const suffix = (0, _ordinal_suffix.getOrdinalSuffix)(this._percentile);
    return `${this._percentile}${suffix} ${await this._source.getAggLabel(this._getAggType(), this.getRootName())}`;
  }
  getName() {
    return `${super.getName()}_${this._percentile}`;
  }
  getValueAggDsl(indexPattern) {
    const field = (0, _elasticsearch_util.getField)(indexPattern, this.getRootName());
    const dsl = (0, _elasticsearch_util.addFieldToDSL)({}, field);
    dsl.percents = [this._percentile];
    return {
      percentiles: dsl
    };
  }
}
exports.PercentileAggField = PercentileAggField;