"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPipelineCreateBreadcrumbs = getPipelineCreateBreadcrumbs;
exports.getPipelineEditBreadcrumbs = getPipelineEditBreadcrumbs;
exports.getPipelineListBreadcrumbs = getPipelineListBreadcrumbs;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getPipelineListBreadcrumbs() {
  return [{
    text: _i18n.i18n.translate('xpack.logstash.pipelines.listBreadcrumb', {
      defaultMessage: 'Pipelines'
    }),
    href: '#/management/ingest/pipelines'
  }];
}
function getPipelineEditBreadcrumbs(pipelineId) {
  return [...getPipelineListBreadcrumbs(), {
    text: pipelineId
  }];
}
function getPipelineCreateBreadcrumbs() {
  return [...getPipelineListBreadcrumbs(), {
    text: _i18n.i18n.translate('xpack.logstash.pipelines.createBreadcrumb', {
      defaultMessage: 'Create'
    })
  }];
}