"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerLensVisualizationsAPIRoutes = registerLensVisualizationsAPIRoutes;
var _create = require("./create");
var _get = require("./get");
var _update = require("./update");
var _delete = require("./delete");
var _search = require("./search");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerLensVisualizationsAPIRoutes({
  http,
  ...rest
}) {
  const {
    versioned: versionedRouter
  } = http.createRouter();
  (0, _create.registerLensVisualizationsCreateAPIRoute)(versionedRouter, rest);
  (0, _get.registerLensVisualizationsGetAPIRoute)(versionedRouter, rest);
  (0, _update.registerLensVisualizationsUpdateAPIRoute)(versionedRouter, rest);
  (0, _delete.registerLensVisualizationsDeleteAPIRoute)(versionedRouter, rest);
  (0, _search.registerLensVisualizationsSearchAPIRoute)(versionedRouter, rest);
}