"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChangeIndexPattern = ChangeIndexPattern;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _calculateWidthFromCharCount = require("@kbn/calculate-width-from-char-count");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/unified-search-plugin/public");
var _react2 = require("@emotion/react");
var _trigger = require("./trigger");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_WIDTH = 600;
const MIN_WIDTH = 320;
function ChangeIndexPattern({
  indexPatternRefs,
  isMissingCurrent,
  indexPatternId,
  onChangeIndexPattern,
  trigger,
  selectableProps
}) {
  const [isPopoverOpen, setPopoverIsOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_trigger.TriggerButton, (0, _extends2.default)({}, trigger, {
      isMissingCurrent: isMissingCurrent,
      togglePopover: () => setPopoverIsOpen(!isPopoverOpen)
    })),
    panelProps: {
      ['data-test-subj']: 'lnsChangeIndexPatternPopover'
    },
    repositionOnScroll: true,
    isOpen: isPopoverOpen,
    closePopover: () => setPopoverIsOpen(false),
    display: "block",
    panelPaddingSize: "none",
    ownFocus: true
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
          width: ${(0, _calculateWidthFromCharCount.calculateWidthFromEntries)(indexPatternRefs, ['name', 'id'], {
      minWidth: MIN_WIDTH,
      maxWidth: MAX_WIDTH
    })}px;
        `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s"
  }, _i18n.i18n.translate('xpack.lens.indexPattern.changeDataViewTitle', {
    defaultMessage: 'Data view'
  })), /*#__PURE__*/_react.default.createElement(_public.DataViewsList, {
    dataViewsList: indexPatternRefs,
    onChangeDataView: newId => {
      onChangeIndexPattern(newId);
      setPopoverIsOpen(false);
    },
    currentDataViewId: indexPatternId,
    selectableProps: selectableProps
  })));
}