"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isTimestampLogColumnConfiguration = exports.isMessageLogColumnConfiguration = exports.isFieldLogColumnConfiguration = exports.getLogColumnConfigurationId = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isFieldLogColumnConfiguration = logColumnConfiguration => logColumnConfiguration != null && 'fieldColumn' in logColumnConfiguration;
exports.isFieldLogColumnConfiguration = isFieldLogColumnConfiguration;
const isMessageLogColumnConfiguration = logColumnConfiguration => logColumnConfiguration != null && 'messageColumn' in logColumnConfiguration;
exports.isMessageLogColumnConfiguration = isMessageLogColumnConfiguration;
const isTimestampLogColumnConfiguration = logColumnConfiguration => logColumnConfiguration != null && 'timestampColumn' in logColumnConfiguration;
exports.isTimestampLogColumnConfiguration = isTimestampLogColumnConfiguration;
const getLogColumnConfigurationId = logColumnConfiguration => {
  if (isTimestampLogColumnConfiguration(logColumnConfiguration)) {
    return logColumnConfiguration.timestampColumn.id;
  } else if (isMessageLogColumnConfiguration(logColumnConfiguration)) {
    return logColumnConfiguration.messageColumn.id;
  } else {
    return logColumnConfiguration.fieldColumn.id;
  }
};
exports.getLogColumnConfigurationId = getLogColumnConfigurationId;