"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SubscriptionSplashPrompt = exports.SubscriptionSplashPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_trial_status = require("../hooks/use_trial_status");
var _loading_page = require("./loading_page");
var _page_template = require("./page_template");
var _use_license = require("../hooks/use_license");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const loadingMessage = _i18n.i18n.translate('xpack.infra.ml.splash.loadingMessage', {
  defaultMessage: 'Checking license...'
});
const SubscriptionSplashPage = templateProps => {
  const {
    loadState,
    isTrialAvailable,
    checkTrialAvailability
  } = (0, _use_trial_status.useTrialStatus)();
  const manageLicenseURL = (0, _use_license.useLicenseUrl)();
  (0, _react.useEffect)(() => {
    checkTrialAvailability();
  }, [checkTrialAvailability]);
  if (loadState === 'pending') {
    return /*#__PURE__*/_react.default.createElement(_loading_page.LoadingPrompt, {
      message: loadingMessage
    });
  }
  const canStartTrial = isTrialAvailable && loadState === 'resolved';
  let title;
  let description;
  let cta;
  if (canStartTrial) {
    title = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.ml.splash.startTrialTitle",
      defaultMessage: "To access anomaly detection, start a free trial"
    });
    description = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.ml.splash.startTrialDescription",
      defaultMessage: "Our free trial includes machine learning features, which enable you to detect anomalies in your logs."
    });
    cta = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "infraSubscriptionSplashPromptStartTrialButton",
      fullWidth: false,
      fill: true,
      href: manageLicenseURL
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.ml.splash.startTrialCta",
      defaultMessage: "Start trial"
    }));
  } else {
    title = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.ml.splash.updateSubscriptionTitle",
      defaultMessage: "To access anomaly detection, upgrade to a Platinum Subscription"
    });
    description = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.ml.splash.updateSubscriptionDescription",
      defaultMessage: "You must have a Platinum Subscription to use machine learning features."
    });
    cta = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "infraSubscriptionSplashPromptUpgradeSubscriptionButton",
      fullWidth: false,
      fill: true,
      href: "https://www.elastic.co/subscriptions"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.ml.splash.updateSubscriptionCta",
      defaultMessage: "Upgrade subscription"
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_page_template.PageTemplate, (0, _extends2.default)({}, templateProps, {
    isEmptyState: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: 'visLine',
    title: /*#__PURE__*/_react.default.createElement("h2", null, title),
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, description)),
    actions: cta
  }));
};
exports.SubscriptionSplashPage = SubscriptionSplashPage;
const SubscriptionSplashPrompt = () => {
  const manageLicenseURL = (0, _use_license.useLicenseUrl)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "logoObservability",
    iconColor: "warning",
    title: /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.infra.ml.splash.trial.title', {
      defaultMessage: 'Discover and resolve infrastructure issues faster with anomaly detection'
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.infra.ml.splash.trial.description', {
      defaultMessage: 'Uncover infrastructure anomalies to preempt issues and resolve them quicker with the aid of machine learning.'
    })),
    actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "infraSubscriptionSplashPromptStartTrialButton",
      href: manageLicenseURL,
      fill: true
    }, _i18n.i18n.translate('xpack.infra.ml.splash.startTrialCta', {
      defaultMessage: 'Start trial'
    }))]
  });
};
exports.SubscriptionSplashPrompt = SubscriptionSplashPrompt;