"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logSourcesKibanaAdvancedSettingRT = exports.logIndexReferenceRT = exports.logIndexPatternReferenceRT = exports.logIndexNameReferenceRT = exports.StaticSourceConfigurationRuntimeType = exports.SourceStatusRuntimeType = exports.SourceRuntimeType = exports.SourceResponseRuntimeType = exports.SourceConfigurationTimestampColumnRuntimeType = exports.SourceConfigurationRuntimeType = exports.SourceConfigurationRT = exports.SourceConfigurationMessageColumnRuntimeType = exports.SourceConfigurationFieldColumnRuntimeType = exports.SourceConfigurationColumnRuntimeType = exports.SavedSourceConfigurationRuntimeType = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * These are the core source configuration types that represent a Source Configuration in
 * it's entirety. There are then subsets of this configuration that form the Logs Source Configuration
 * and Metrics Source Configuration. The Logs Source Configuration is further expanded to it's resolved form.
 * -> Source Configuration
 *  -> Logs source configuration
 *    -> Resolved Logs Source Configuration
 *  -> Metrics Source Configuration
 */

/* eslint-disable @typescript-eslint/no-empty-interface */

/**
 * Log columns
 */

const SourceConfigurationTimestampColumnRuntimeType = exports.SourceConfigurationTimestampColumnRuntimeType = rt.type({
  timestampColumn: rt.type({
    id: rt.string
  })
});
const SourceConfigurationMessageColumnRuntimeType = exports.SourceConfigurationMessageColumnRuntimeType = rt.type({
  messageColumn: rt.type({
    id: rt.string
  })
});
const SourceConfigurationFieldColumnRuntimeType = exports.SourceConfigurationFieldColumnRuntimeType = rt.type({
  fieldColumn: rt.type({
    id: rt.string,
    field: rt.string
  })
});
const SourceConfigurationColumnRuntimeType = exports.SourceConfigurationColumnRuntimeType = rt.union([SourceConfigurationTimestampColumnRuntimeType, SourceConfigurationMessageColumnRuntimeType, SourceConfigurationFieldColumnRuntimeType]);
/**
 * Log indices
 */

// Kibana index pattern
const logIndexPatternReferenceRT = exports.logIndexPatternReferenceRT = rt.type({
  type: rt.literal('index_pattern'),
  indexPatternId: rt.string
});
// Legacy support
const logIndexNameReferenceRT = exports.logIndexNameReferenceRT = rt.type({
  type: rt.literal('index_name'),
  indexName: rt.string
});
// Kibana advanced setting
const logSourcesKibanaAdvancedSettingRT = exports.logSourcesKibanaAdvancedSettingRT = rt.type({
  type: rt.literal('kibana_advanced_setting')
});
const logIndexReferenceRT = exports.logIndexReferenceRT = rt.union([logIndexPatternReferenceRT, logIndexNameReferenceRT, logSourcesKibanaAdvancedSettingRT]);
const SourceConfigurationRT = exports.SourceConfigurationRT = rt.type({
  name: rt.string,
  description: rt.string,
  metricAlias: rt.string,
  logIndices: logIndexReferenceRT,
  inventoryDefaultView: rt.string,
  metricsExplorerDefaultView: rt.string,
  logColumns: rt.array(SourceConfigurationColumnRuntimeType),
  anomalyThreshold: rt.number
});

/**
 * Stored source configuration as read from and written to saved objects
 */

const SavedSourceConfigurationRuntimeType = exports.SavedSourceConfigurationRuntimeType = rt.partial(SourceConfigurationRT.props);
/**
 * Static source configuration, the result of merging values from the config file and
 * hardcoded defaults.
 */

const StaticSourceConfigurationRuntimeType = exports.StaticSourceConfigurationRuntimeType = rt.partial({
  ...SourceConfigurationRT.props
});
/**
 * Full source configuration type after all cleanup has been done at the edges
 */

const SourceConfigurationRuntimeType = exports.SourceConfigurationRuntimeType = rt.type({
  ...SourceConfigurationRT.props,
  logColumns: rt.array(SourceConfigurationColumnRuntimeType)
});
/**
 * Source status
 */

const SourceStatusRuntimeType = exports.SourceStatusRuntimeType = rt.type({
  logIndicesExist: rt.boolean,
  metricIndicesExist: rt.boolean,
  remoteClustersExist: rt.boolean
});
/**
 * Source configuration along with source status and metadata
 */
const SourceRuntimeType = exports.SourceRuntimeType = rt.intersection([rt.type({
  id: rt.string,
  origin: rt.keyof({
    fallback: null,
    internal: null,
    stored: null
  }),
  configuration: SourceConfigurationRuntimeType
}), rt.partial({
  version: rt.string,
  updatedAt: rt.number,
  status: SourceStatusRuntimeType
})]);
const SourceResponseRuntimeType = exports.SourceResponseRuntimeType = rt.type({
  source: SourceRuntimeType
});