"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.graphRouter = void 0;
var _react = _interopRequireDefault(require("react"));
var _history = require("history");
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _listing_route = require("./apps/listing_route");
var _workspace_route = require("./apps/workspace_route");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const graphRouter = deps => {
  const history = (0, _history.createHashHistory)();
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: "/home"
  }, /*#__PURE__*/_react.default.createElement(_listing_route.ListingRoute, {
    deps: deps
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/workspace/:id?"
  }, /*#__PURE__*/_react.default.createElement(_workspace_route.WorkspaceRoute, {
    deps: deps
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, null, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    exact: true,
    to: "/home"
  }))));
};
exports.graphRouter = graphRouter;