"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackagePolicyAgentsCell = exports.AgentsCountBreakDown = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _components = require("../../../../../../components");
var _services = require("../../../../../../services");
var _hooks = require("../../../../../../hooks");
var _constants = require("../../../../../../constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddAgentButton = ({
  onAddAgent,
  canAddAgents,
  withPopover
}) => {
  const [isHelpOpen, setIsHelpOpen] = (0, _react.useState)(true);
  const onAddAgentCloseHelp = () => {
    setIsHelpOpen(false);
    onAddAgent();
  };
  return withPopover ? /*#__PURE__*/_react.default.createElement(_components.AddAgentHelpPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "plusInCircle",
      "data-test-subj": "addAgentButton",
      onClick: onAddAgentCloseHelp,
      size: "s",
      isDisabled: !canAddAgents
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epm.packageDetails.integrationList.addAgent",
      defaultMessage: "Add agent"
    })),
    isOpen: isHelpOpen,
    closePopover: () => setIsHelpOpen(false)
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "plusInCircle",
    "data-test-subj": "addAgentButton",
    onClick: onAddAgent,
    size: "s",
    isDisabled: !canAddAgents
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.packageDetails.integrationList.addAgent",
    defaultMessage: "Add agent"
  }));
};
const PackagePolicyAgentsCell = ({
  agentPolicies,
  onAddAgent,
  hasHelpPopover = false
}) => {
  const {
    canUseMultipleAgentPolicies
  } = (0, _hooks.useMultipleAgentPolicies)();
  const agentCount = agentPolicies.reduce((acc, curr) => {
    return acc += (curr === null || curr === void 0 ? void 0 : curr.agents) || 0;
  }, 0);
  const canAddAgents = (0, _hooks.useAuthz)().fleet.addAgents;
  const canAddFleetServers = (0, _hooks.useAuthz)().fleet.addFleetServers;
  if (canUseMultipleAgentPolicies && agentCount > 0 && agentPolicies.length > 1) {
    return /*#__PURE__*/_react.default.createElement(AgentsCountBreakDown, {
      agentCount: agentCount,
      agentPolicies: agentPolicies
    });
  }
  if (!canUseMultipleAgentPolicies || agentCount > 0 && agentPolicies.length === 1) {
    const agentPolicy = agentPolicies[0];
    const canAddAgentsForPolicy = (0, _services.policyHasFleetServer)(agentPolicy) ? canAddFleetServers : canAddAgents;
    if (agentCount > 0 || agentPolicy.is_managed) return /*#__PURE__*/_react.default.createElement(_components.LinkedAgentCount, {
      count: agentCount,
      agentPolicyId: agentPolicy.id,
      className: "eui-textTruncate"
    });else {
      /*#__PURE__*/_react.default.createElement(AddAgentButton, {
        onAddAgent: onAddAgent,
        canAddAgents: canAddAgentsForPolicy
      });
    }
  }
  return /*#__PURE__*/_react.default.createElement(AddAgentButton, {
    onAddAgent: onAddAgent,
    canAddAgents: canAddAgents && canAddFleetServers,
    withPopover: hasHelpPopover
  });
};
exports.PackagePolicyAgentsCell = PackagePolicyAgentsCell;
const AgentsCountBreakDown = ({
  agentPolicies,
  agentCount,
  privilegeMode
}) => {
  const {
    getHref
  } = (0, _hooks.useLink)();
  const authz = (0, _hooks.useAuthz)();
  const canReadAgents = authz.fleet.readAgents;
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const closePopover = () => setIsPopoverOpen(false);
  const getKuery = agentPolicyId => `${_constants.AGENTS_PREFIX}.policy_id : "${agentPolicyId}"${privilegeMode ? ` and ${privilegeMode === 'unprivileged' ? _constants.UNPRIVILEGED_AGENT_KUERY : _constants.PRIVILEGED_AGENT_KUERY}` : ''}`;
  const topFivePolicies = (0, _react.useMemo)(() => (0, _lodash.sortBy)(agentPolicies, 'agents').reverse().slice(0, 5), [agentPolicies]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": "agentCountsPopover",
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    anchorPosition: "downCenter",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      flush: "left",
      onClick: () => setIsPopoverOpen(!isPopoverOpen),
      "data-test-subj": "agentsCountsButton"
    }, agentCount)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, _i18n.i18n.translate('xpack.fleet.agentsCountsBreakdown.popover.title', {
    defaultMessage: 'Agents breakdown'
  })), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      minWidth: 300
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("b", null, _i18n.i18n.translate('xpack.fleet.agentsCountsBreakdown.popover.heading', {
    defaultMessage: 'Top values'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), topFivePolicies.map(agentPolicy => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: agentPolicy.id
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    key: agentPolicy.id
  }, agentPolicy.name)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, agentPolicy !== null && agentPolicy !== void 0 && agentPolicy.agents && agentPolicy.agents > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: getHref('agent_list', {
      kuery: getKuery(agentPolicy.id),
      showInactive: true
    })
  }, agentPolicy.agents) : 0)), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), agentCount > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fullWidth: true,
    size: "s",
    "data-test-subj": "agentsCountsBreakdownPopoverButton",
    href: getHref('agent_list', {
      showInactive: true
    }),
    isDisabled: !canReadAgents
  }, _i18n.i18n.translate('xpack.fleet.agentsCountsBreakdown.popover.button', {
    defaultMessage: 'View all {agentCount, plural, one {# agent} other {# agents}}',
    values: {
      agentCount
    }
  }))) : null)));
};
exports.AgentsCountBreakDown = AgentsCountBreakDown;