"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionColumn = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _constants = require("../../constants");
var _inline_editable_table_logic = require("./inline_editable_table_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ActionColumn = ({
  emptyPropertyAllowed = false,
  displayedItems,
  isActivelyEditing,
  isLoading = false,
  item,
  canRemoveLastItem,
  lastItemWarning,
  uneditableItems,
  prevFocusRef
}) => {
  const {
    doesEditingItemValueContainEmptyProperty,
    fieldErrors,
    rowErrors,
    isEditingUnsavedItem
  } = (0, _kea.useValues)(_inline_editable_table_logic.InlineEditableTableLogic);
  const {
    editExistingItem,
    deleteItem,
    doneEditing,
    saveExistingItem,
    saveNewItem
  } = (0, _kea.useActions)(_inline_editable_table_logic.InlineEditableTableLogic);
  if (uneditableItems !== null && uneditableItems !== void 0 && uneditableItems.includes(item)) {
    return null;
  }
  const handleEditExistingItem = () => {
    if (prevFocusRef) {
      prevFocusRef.current = document.activeElement;
    }
    editExistingItem(item);
  };
  const isInvalid = Object.keys(fieldErrors).length > 0 || rowErrors.length > 0;
  if (isActivelyEditing(item)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "aria-label": _constants.SAVE_BUTTON_LABEL,
      "data-test-subj": "saveButton",
      color: "primary",
      iconType: "checkInCircleFilled",
      onClick: isEditingUnsavedItem ? saveNewItem : saveExistingItem,
      disabled: isLoading || isInvalid || doesEditingItemValueContainEmptyProperty && !emptyPropertyAllowed
    }, _constants.SAVE_BUTTON_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "aria-label": _constants.CANCEL_BUTTON_LABEL,
      "data-test-subj": "cancelButton",
      color: "danger",
      iconType: "cross",
      onClick: doneEditing,
      disabled: isLoading
    }, _constants.CANCEL_BUTTON_LABEL)));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: null
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": _constants.EDIT_BUTTON_LABEL,
    "data-test-subj": "editButton",
    size: "xs",
    onClick: handleEditExistingItem
  }, _constants.EDIT_BUTTON_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: null
  }, !canRemoveLastItem && displayedItems.length === 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: lastItemWarning
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": _constants.DELETE_BUTTON_LABEL,
    size: "xs",
    disabled: true
  }, _constants.DELETE_BUTTON_LABEL)) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": _constants.DELETE_BUTTON_LABEL,
    "data-test-subj": "deleteButton",
    size: "xs",
    onClick: () => deleteItem(item)
  }, _constants.DELETE_BUTTON_LABEL)));
};
exports.ActionColumn = ActionColumn;