"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotFoundPrompt = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _constants = require("../../../../common/constants");
var _licensing = require("../licensing");
var _react_router_helpers = require("../react_router_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NotFoundPrompt = ({
  productSupportUrl,
  backToLink = '/',
  backToContent
}) => {
  const {
    hasGoldLicense
  } = (0, _kea.useValues)(_licensing.LicensingLogic);
  const supportUrl = hasGoldLicense ? _constants.LICENSED_SUPPORT_URL : productSupportUrl;
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.EmptyPrompt, {
    iconType: "logoElasticsearch",
    title: /*#__PURE__*/_react.default.createElement("h1", null, _i18n.i18n.translate('xpack.enterpriseSearch.notFound.title', {
      defaultMessage: '404 error'
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.notFound.description', {
      defaultMessage: 'The page you’re looking for was not found.'
    })),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
      to: backToLink,
      fill: true
    }, backToContent !== null && backToContent !== void 0 ? backToContent : _i18n.i18n.translate('xpack.enterpriseSearch.notFound.action1', {
      defaultMessage: 'Back to your dashboard'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      href: supportUrl,
      target: "_blank"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.notFound.action2', {
      defaultMessage: 'Contact support'
    }))))
  });
};
exports.NotFoundPrompt = NotFoundPrompt;