"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddContentEmptyPrompt = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _welcome_dark = _interopRequireDefault(require("../../../assets/images/welcome_dark.svg"));
var _welcome_light = _interopRequireDefault(require("../../../assets/images/welcome_light.svg"));
var _doc_links = require("../doc_links");
require("./add_content_empty_prompt.scss");
var _kibana = require("../kibana");
var _react_router_helpers = require("../react_router_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddContentEmptyPrompt = () => {
  var _share$url$locators$g, _share$url$locators$g2;
  const {
    colorMode
  } = (0, _eui.useEuiTheme)();
  const {
    share
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const createIndexUrl = (_share$url$locators$g = share === null || share === void 0 ? void 0 : (_share$url$locators$g2 = share.url.locators.get('SEARCH_CREATE_INDEX')) === null || _share$url$locators$g2 === void 0 ? void 0 : _share$url$locators$g2.useUrl({})) !== null && _share$url$locators$g !== void 0 ? _share$url$locators$g : '';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    layout: "horizontal",
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.addContentEmptyPrompt.h2.createYourFirstIndexLabel",
      defaultMessage: "Create your first Index"
    })),
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, _i18n.i18n.translate('xpack.enterpriseSearch.addContentEmptyPrompt.onceCreatedThisPageLabel', {
      defaultMessage: 'Once created, this page will list all of your indices'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
      to: createIndexUrl,
      shouldNotCreateHref: true,
      shouldNotPrepend: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      fill: true,
      iconType: "plusInCircle"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.addContentEmptyPrompt.newIndexButtonLabel', {
      defaultMessage: 'New Index'
    })))))),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement("b", null, _i18n.i18n.translate('xpack.enterpriseSearch.addContentEmptyPrompt.wantToLearnMoreLabel', {
      defaultMessage: 'Want to learn more?'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: _doc_links.docLinks.start,
      target: "_blank"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.overview.emptyState.footerLinkTitle', {
      defaultMessage: 'Learn more'
    })))),
    hasBorder: true,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      size: "fullWidth",
      src: colorMode === 'LIGHT' ? _welcome_light.default : _welcome_dark.default,
      alt: ""
    })
  });
};
exports.AddContentEmptyPrompt = AddContentEmptyPrompt;