"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ASSISTANT_GRAPH_MAP = void 0;
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _graph = require("./default_assistant_graph/graph");
var _default_attack_discovery_graph = require("../../attack_discovery/graphs/default_attack_discovery_graph");
var _default_defend_insights_graph = require("../../defend_insights/graphs/default_defend_insights_graph");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Map of the different Assistant Graphs. Useful for running evaluations.
 */
const ASSISTANT_GRAPH_MAP = exports.ASSISTANT_GRAPH_MAP = {
  DefaultAssistantGraph: {
    getDefaultAssistantGraph: _graph.getDefaultAssistantGraph,
    graphType: 'assistant'
  },
  DefaultAttackDiscoveryGraph: {
    getDefaultAttackDiscoveryGraph: _default_attack_discovery_graph.getDefaultAttackDiscoveryGraph,
    graphType: 'attack-discovery'
  },
  DefaultDefendInsightsGraph: {
    getDefaultDefendInsightsGraph: _default_defend_insights_graph.getDefaultDefendInsightsGraph,
    graphType: _elasticAssistantCommon.DEFEND_INSIGHTS_ID
  }
};