"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertScheduleActionsToAlertingActions = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isAlertingActions = action => {
  return action.group != null;
};
const convertScheduleActionsToAlertingActions = ({
  actionsClient,
  logger,
  scheduleActions
}) => {
  return (scheduleActions !== null && scheduleActions !== void 0 ? scheduleActions : []).reduce((acc, value) => {
    if (actionsClient.isSystemAction(value.id)) {
      acc.systemActions.push(value);
    } else {
      if (isAlertingActions(value)) {
        acc.actions.push(value);
      } else {
        logger.error(`Missing group for non-system action ${value.id} of type ${value.actionTypeId}`);
      }
    }
    return acc;
  }, {
    actions: [],
    systemActions: []
  });
};
exports.convertScheduleActionsToAlertingActions = convertScheduleActionsToAlertingActions;