"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TraceData = exports.SecurityAlertsPageContentReference = exports.SecurityAlertContentReference = exports.Replacements = exports.Reader = exports.ProviderEnum = exports.Provider = exports.ProductDocumentationContentReference = exports.MessageRoleEnum = exports.MessageRole = exports.MessageMetadata = exports.Message = exports.KnowledgeBaseEntryContentReference = exports.HrefContentReference = exports.EsqlContentReference = exports.ErrorSchema = exports.ConversationUpdateProps = exports.ConversationSummary = exports.ConversationResponse = exports.ConversationMessageCreateProps = exports.ConversationCreateProps = exports.ConversationConfidenceEnum = exports.ConversationConfidence = exports.ConversationCategoryEnum = exports.ConversationCategory = exports.ContentReferences = exports.ContentReferenceInternal = exports.ContentReference = exports.BaseContentReference = exports.ApiConfig = void 0;
var _zod = require("@kbn/zod");
var _common_attributes = require("../common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Common Conversation Attributes
 *   version: not applicable
 */

/**
 * Trace Data
 */

const TraceData = exports.TraceData = _zod.z.object({
  /**
   * Could be any string, not necessarily a UUID
   */
  transactionId: _zod.z.string().optional(),
  /**
   * Could be any string, not necessarily a UUID
   */
  traceId: _zod.z.string().optional()
});

/**
 * The basis of a content reference
 */

const BaseContentReference = exports.BaseContentReference = _zod.z.object({
  /**
   * Id of the content reference
   */
  id: _zod.z.string(),
  /**
   * Type of the content reference
   */
  type: _zod.z.string()
});

/**
 * References a knowledge base entry
 */

const KnowledgeBaseEntryContentReference = exports.KnowledgeBaseEntryContentReference = BaseContentReference.merge(_zod.z.object({
  type: _zod.z.literal('KnowledgeBaseEntry'),
  /**
   * Id of the Knowledge Base Entry
   */
  knowledgeBaseEntryId: _zod.z.string(),
  /**
   * Name of the knowledge base entry
   */
  knowledgeBaseEntryName: _zod.z.string()
}));

/**
 * References an ESQL query
 */

const EsqlContentReference = exports.EsqlContentReference = BaseContentReference.merge(_zod.z.object({
  type: _zod.z.literal('EsqlQuery'),
  /**
   * An ESQL query
   */
  query: _zod.z.string(),
  /**
   * Label of the query
   */
  label: _zod.z.string(),
  /**
   * Time range to select in the time picker.
   */
  timerange: _zod.z.object({
    from: _zod.z.string(),
    to: _zod.z.string()
  }).optional()
}));

/**
 * References a security alert
 */

const SecurityAlertContentReference = exports.SecurityAlertContentReference = BaseContentReference.merge(_zod.z.object({
  type: _zod.z.literal('SecurityAlert'),
  /**
   * ID of the Alert
   */
  alertId: _zod.z.string()
}));

/**
 * References an external URL
 */

const HrefContentReference = exports.HrefContentReference = BaseContentReference.merge(_zod.z.object({
  type: _zod.z.literal('Href'),
  /**
   * Label of the query
   */
  label: _zod.z.string().optional(),
  /**
   * URL to the external resource
   */
  href: _zod.z.string()
}));

/**
 * References the security alerts page
 */

const SecurityAlertsPageContentReference = exports.SecurityAlertsPageContentReference = BaseContentReference.merge(_zod.z.object({
  type: _zod.z.literal('SecurityAlertsPage')
}));

/**
 * References the product documentation
 */

const ProductDocumentationContentReference = exports.ProductDocumentationContentReference = BaseContentReference.merge(_zod.z.object({
  type: _zod.z.literal('ProductDocumentation'),
  /**
   * Title of the documentation
   */
  title: _zod.z.string(),
  /**
   * URL to the documentation
   */
  url: _zod.z.string()
}));

/**
 * A content reference
 */
const ContentReferenceInternal = exports.ContentReferenceInternal = _zod.z.union([KnowledgeBaseEntryContentReference, SecurityAlertContentReference, SecurityAlertsPageContentReference, ProductDocumentationContentReference, EsqlContentReference, HrefContentReference]);
const ContentReference = exports.ContentReference = ContentReferenceInternal;

/**
 * A union of all content reference types
 */

const ContentReferences = exports.ContentReferences = _zod.z.object({}).catchall(_zod.z.union([KnowledgeBaseEntryContentReference, SecurityAlertContentReference, SecurityAlertsPageContentReference, ProductDocumentationContentReference, EsqlContentReference, HrefContentReference]));

/**
 * Message metadata
 */

const MessageMetadata = exports.MessageMetadata = _zod.z.object({
  /**
   * Data referred to by the message content.
   */
  contentReferences: ContentReferences.optional()
});

/**
 * Replacements object used to anonymize/deanonymize messages
 */

const Replacements = exports.Replacements = _zod.z.object({}).catchall(_zod.z.string());
const Reader = exports.Reader = _zod.z.object({}).catchall(_zod.z.unknown());

/**
 * Provider
 */

const Provider = exports.Provider = _zod.z.enum(['OpenAI', 'Azure OpenAI', 'Other']);
const ProviderEnum = exports.ProviderEnum = Provider.enum;

/**
 * Message role.
 */

const MessageRole = exports.MessageRole = _zod.z.enum(['system', 'user', 'assistant']);
const MessageRoleEnum = exports.MessageRoleEnum = MessageRole.enum;

/**
 * The conversation category.
 */

const ConversationCategory = exports.ConversationCategory = _zod.z.enum(['assistant', 'insights']);
const ConversationCategoryEnum = exports.ConversationCategoryEnum = ConversationCategory.enum;

/**
 * The conversation confidence.
 */

const ConversationConfidence = exports.ConversationConfidence = _zod.z.enum(['low', 'medium', 'high']);
const ConversationConfidenceEnum = exports.ConversationConfidenceEnum = ConversationConfidence.enum;

/**
 * AI assistant conversation message.
 */

const Message = exports.Message = _zod.z.object({
  /**
   * Message content.
   */
  content: _zod.z.string(),
  /**
   * Message content.
   */
  reader: Reader.optional(),
  /**
   * Message role.
   */
  role: MessageRole,
  /**
   * The timestamp message was sent or received.
   */
  timestamp: _common_attributes.NonEmptyTimestamp,
  /**
   * Is error message.
   */
  isError: _zod.z.boolean().optional(),
  /**
   * Trace data
   */
  traceData: TraceData.optional(),
  /**
   * Metadata
   */
  metadata: MessageMetadata.optional()
});
const ApiConfig = exports.ApiConfig = _zod.z.object({
  /**
   * Connector ID
   */
  connectorId: _zod.z.string(),
  /**
   * Action type ID
   */
  actionTypeId: _zod.z.string(),
  /**
   * Default system prompt ID
   */
  defaultSystemPromptId: _zod.z.string().optional(),
  /**
   * Provider
   */
  provider: Provider.optional(),
  /**
   * Model
   */
  model: _zod.z.string().optional()
});
const ConversationSummary = exports.ConversationSummary = _zod.z.object({
  /**
   * Summary text of the conversation over time.
   */
  content: _zod.z.string().optional(),
  /**
   * The timestamp summary was updated.
   */
  timestamp: _common_attributes.NonEmptyTimestamp.optional(),
  /**
   * Define if summary is marked as publicly available.
   */
  public: _zod.z.boolean().optional(),
  /**
   * How confident you are about this being a correct and useful learning.
   */
  confidence: ConversationConfidence.optional()
});
const ErrorSchema = exports.ErrorSchema = _zod.z.object({
  id: _common_attributes.NonEmptyString.optional(),
  error: _zod.z.object({
    status_code: _zod.z.number().int().min(400),
    message: _zod.z.string()
  })
}).strict();
const ConversationResponse = exports.ConversationResponse = _zod.z.object({
  id: _common_attributes.NonEmptyString,
  /**
   * The conversation title.
   */
  title: _zod.z.string(),
  /**
   * The conversation category.
   */
  category: ConversationCategory,
  summary: ConversationSummary.optional(),
  timestamp: _common_attributes.NonEmptyTimestamp.optional(),
  /**
   * The last time conversation was updated.
   */
  updatedAt: _zod.z.string().optional(),
  /**
   * The time conversation was created.
   */
  createdAt: _zod.z.string(),
  replacements: Replacements.optional(),
  users: _zod.z.array(_common_attributes.User),
  /**
   * The conversation messages.
   */
  messages: _zod.z.array(Message).optional(),
  /**
   * LLM API configuration.
   */
  apiConfig: ApiConfig.optional(),
  /**
   * Exclude from last conversation storage.
   */
  excludeFromLastConversationStorage: _zod.z.boolean().optional(),
  /**
   * Kibana space
   */
  namespace: _zod.z.string()
});
const ConversationUpdateProps = exports.ConversationUpdateProps = _zod.z.object({
  id: _common_attributes.NonEmptyString,
  /**
   * The conversation title.
   */
  title: _zod.z.string().optional(),
  /**
   * The conversation category.
   */
  category: ConversationCategory.optional(),
  /**
   * The conversation messages.
   */
  messages: _zod.z.array(Message).optional(),
  /**
   * LLM API configuration.
   */
  apiConfig: ApiConfig.optional(),
  summary: ConversationSummary.optional(),
  /**
   * Exclude from last conversation storage.
   */
  excludeFromLastConversationStorage: _zod.z.boolean().optional(),
  replacements: Replacements.optional()
});
const ConversationCreateProps = exports.ConversationCreateProps = _zod.z.object({
  /**
   * The conversation id.
   */
  id: _zod.z.string().optional(),
  /**
   * The conversation title.
   */
  title: _zod.z.string(),
  /**
   * The conversation category.
   */
  category: ConversationCategory.optional(),
  /**
   * The conversation messages.
   */
  messages: _zod.z.array(Message).optional(),
  /**
   * LLM API configuration.
   */
  apiConfig: ApiConfig.optional(),
  /**
   * Exclude from last conversation storage.
   */
  excludeFromLastConversationStorage: _zod.z.boolean().optional(),
  replacements: Replacements.optional()
});
const ConversationMessageCreateProps = exports.ConversationMessageCreateProps = _zod.z.object({
  /**
   * The conversation messages.
   */
  messages: _zod.z.array(Message)
});