"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeSession = void 0;
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/saved-search-plugin/public");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _internal_state = require("../internal_state");
var _discover_app_state_container = require("../../discover_app_state_container");
var _data_views = require("./data_views");
var _cleanup_url_state = require("../../utils/cleanup_url_state");
var _breadcrumbs = require("../../../../../utils/breadcrumbs");
var _get_esql_data_view = require("../../utils/get_esql_data_view");
var _resolve_data_view = require("../../utils/resolve_data_view");
var _data_sources = require("../../../../../../common/data_sources");
var _discover_saved_search_container = require("../../discover_saved_search_container");
var _validate_time = require("../../../../../utils/validate_time");
var _get_valid_filters = require("../../../../../utils/get_valid_filters");
var _update_saved_search = require("../../utils/update_saved_search");
var _common = require("../../../../../../common");
var _constants = require("../../../../../constants");
var _runtime_state = require("../runtime_state");
var _tabs = require("./tabs");
var _selectors = require("../selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const initializeSession = ({
  tabId,
  initializeSessionParams: {
    stateContainer,
    customizationService,
    discoverSessionId,
    dataViewSpec,
    defaultUrlState,
    shouldClearAllTabs
  }
}) => async (dispatch, getState, {
  services,
  customizationContext,
  runtimeStateManager,
  urlStateStorage,
  tabsStorageManager
}) => {
  var _urlState$query, _urlState, _stateContainer$globa, _stateContainer$globa2, _services$filterManag, _initialState$filters;
  dispatch((0, _tabs.disconnectTab)({
    tabId
  }));
  dispatch(_internal_state.internalStateSlice.actions.resetOnSavedSearchChange({
    tabId
  }));
  if (_constants.TABS_ENABLED && shouldClearAllTabs) {
    dispatch((0, _tabs.clearAllTabs)());
  }
  const {
    currentDataView$,
    stateContainer$,
    customizationService$,
    scopedProfilesManager$,
    scopedEbtManager$
  } = (0, _runtime_state.selectTabRuntimeState)(runtimeStateManager, tabId);
  const tabState = (0, _selectors.selectTab)(getState(), tabId);
  let urlState = (0, _cleanup_url_state.cleanupUrlState)(defaultUrlState !== null && defaultUrlState !== void 0 ? defaultUrlState : urlStateStorage.get(_common.APP_STATE_URL_KEY), services.uiSettings);

  /**
   * New tab initialization with the restored data if available
   */

  const wasTabInitialized = Boolean(stateContainer$.getValue());
  if (wasTabInitialized) {
    // Clear existing runtime state on re-initialization
    // to ensure no stale state is used during loading
    currentDataView$.next(undefined);
    stateContainer$.next(undefined);
    customizationService$.next(undefined);
    scopedEbtManager$.next(services.ebtManager.createScopedEBTManager());
    scopedProfilesManager$.next(services.profilesManager.createScopedProfilesManager({
      scopedEbtManager: scopedEbtManager$.getValue()
    }));
  }
  if (_constants.TABS_ENABLED && !wasTabInitialized) {
    const tabInitialGlobalState = tabState.initialGlobalState;
    if (tabInitialGlobalState !== null && tabInitialGlobalState !== void 0 && tabInitialGlobalState.filters) {
      services.filterManager.setGlobalFilters((0, _lodash.cloneDeep)(tabInitialGlobalState.filters));
    }
    if (tabInitialGlobalState !== null && tabInitialGlobalState !== void 0 && tabInitialGlobalState.timeRange) {
      services.timefilter.setTime(tabInitialGlobalState.timeRange);
    }
    if (tabInitialGlobalState !== null && tabInitialGlobalState !== void 0 && tabInitialGlobalState.refreshInterval) {
      services.timefilter.setRefreshInterval(tabInitialGlobalState.refreshInterval);
    }
    const tabInitialAppState = tabState.initialAppState;
    if (tabInitialAppState) {
      urlState = (0, _lodash.cloneDeep)(tabInitialAppState);
    }
  }
  const discoverSessionLoadTracker = scopedEbtManager$.getValue().trackPerformanceEvent('discoverLoadSavedSearch');
  const persistedDiscoverSession = discoverSessionId ? await services.savedSearch.get(discoverSessionId) : undefined;
  const initialQuery = (_urlState$query = (_urlState = urlState) === null || _urlState === void 0 ? void 0 : _urlState.query) !== null && _urlState$query !== void 0 ? _urlState$query : persistedDiscoverSession === null || persistedDiscoverSession === void 0 ? void 0 : persistedDiscoverSession.searchSource.getField('query');
  const isEsqlMode = (0, _esQuery.isOfAggregateQueryType)(initialQuery);
  const discoverSessionDataView = persistedDiscoverSession === null || persistedDiscoverSession === void 0 ? void 0 : persistedDiscoverSession.searchSource.getField('index');
  const discoverSessionHasAdHocDataView = Boolean(discoverSessionDataView && !discoverSessionDataView.isPersisted());
  const {
    initializationState,
    defaultProfileAdHocDataViewIds
  } = getState();
  const profileDataViews = runtimeStateManager.adHocDataViews$.getValue().filter(({
    id
  }) => id && defaultProfileAdHocDataViewIds.includes(id));
  const profileDataViewsExist = profileDataViews.length > 0;
  const locationStateHasDataViewSpec = Boolean(dataViewSpec);
  const canAccessWithoutPersistedDataView = isEsqlMode || discoverSessionHasAdHocDataView || profileDataViewsExist || locationStateHasDataViewSpec;
  if (!initializationState.hasUserDataView && !canAccessWithoutPersistedDataView) {
    return {
      showNoDataPage: true
    };
  }

  /**
   * Session initialization
   */

  // TODO: Needs to happen when switching tabs too?
  if (customizationContext.displayMode === 'standalone' && persistedDiscoverSession) {
    if (persistedDiscoverSession.id) {
      var _persistedDiscoverSes;
      services.chrome.recentlyAccessed.add((0, _public.getSavedSearchFullPathUrl)(persistedDiscoverSession.id), (_persistedDiscoverSes = persistedDiscoverSession.title) !== null && _persistedDiscoverSes !== void 0 ? _persistedDiscoverSes : _i18n.i18n.translate('discover.defaultDiscoverSessionTitle', {
        defaultMessage: 'Untitled Discover session'
      }), persistedDiscoverSession.id);
    }
    (0, _breadcrumbs.setBreadcrumbs)({
      services,
      titleBreadcrumbText: persistedDiscoverSession.title
    });
  }
  let dataView;
  if ((0, _esQuery.isOfAggregateQueryType)(initialQuery)) {
    // Regardless of what was requested, we always use ad hoc data views for ES|QL
    dataView = await (0, _get_esql_data_view.getEsqlDataView)(initialQuery, discoverSessionDataView !== null && discoverSessionDataView !== void 0 ? discoverSessionDataView : currentDataView$.getValue(), services);
  } else {
    var _urlState2, _urlState3;
    // Load the requested data view if one exists, or a fallback otherwise
    const result = await (0, _resolve_data_view.loadAndResolveDataView)({
      dataViewId: (0, _data_sources.isDataViewSource)((_urlState2 = urlState) === null || _urlState2 === void 0 ? void 0 : _urlState2.dataSource) ? (_urlState3 = urlState) === null || _urlState3 === void 0 ? void 0 : _urlState3.dataSource.dataViewId : discoverSessionDataView === null || discoverSessionDataView === void 0 ? void 0 : discoverSessionDataView.id,
      dataViewSpec,
      savedSearch: persistedDiscoverSession,
      isEsqlMode,
      services,
      internalState: stateContainer.internalState,
      runtimeStateManager
    });
    dataView = result.dataView;
  }
  dispatch((0, _data_views.setDataView)({
    tabId,
    dataView
  }));
  if (!dataView.isPersisted()) {
    dispatch((0, _data_views.appendAdHocDataViews)(dataView));
  }

  // This must be executed before updateSavedSearch since
  // it updates the Discover session with timefilter values
  if (persistedDiscoverSession !== null && persistedDiscoverSession !== void 0 && persistedDiscoverSession.timeRestore && dataView.isTimeBased()) {
    const {
      timeRange,
      refreshInterval
    } = persistedDiscoverSession;
    if (timeRange && (0, _validate_time.isTimeRangeValid)(timeRange)) {
      services.timefilter.setTime(timeRange);
    }
    if (refreshInterval && (0, _validate_time.isRefreshIntervalValid)(refreshInterval)) {
      services.timefilter.setRefreshInterval(refreshInterval);
    }
  }

  // Get the initial state based on a combo of the URL and persisted session,
  // then get an updated copy of the session with the applied initial state
  const initialState = (0, _discover_app_state_container.getInitialState)({
    initialUrlState: urlState,
    savedSearch: persistedDiscoverSession,
    overrideDataView: dataView,
    services
  });
  const discoverSession = (0, _update_saved_search.updateSavedSearch)({
    savedSearch: persistedDiscoverSession ? (0, _discover_saved_search_container.copySavedSearch)(persistedDiscoverSession) : services.savedSearch.getNew(),
    dataView,
    state: initialState,
    globalStateContainer: stateContainer.globalState,
    services
  });

  /**
   * Sync global services
   */

  // Cleaning up the previous state
  services.filterManager.setAppFilters([]);
  services.data.query.queryString.clearQuery();

  // Sync global filters (coming from URL) to filter manager.
  // It needs to be done manually here as `syncGlobalQueryStateWithUrl` is called later.
  const globalFilters = (_stateContainer$globa = stateContainer.globalState) === null || _stateContainer$globa === void 0 ? void 0 : (_stateContainer$globa2 = _stateContainer$globa.get()) === null || _stateContainer$globa2 === void 0 ? void 0 : _stateContainer$globa2.filters;
  const shouldUpdateWithGlobalFilters = (globalFilters === null || globalFilters === void 0 ? void 0 : globalFilters.length) && !((_services$filterManag = services.filterManager.getGlobalFilters()) !== null && _services$filterManag !== void 0 && _services$filterManag.length);
  if (shouldUpdateWithGlobalFilters) {
    services.filterManager.setGlobalFilters(globalFilters);
  }

  // set data service filters
  if ((_initialState$filters = initialState.filters) !== null && _initialState$filters !== void 0 && _initialState$filters.length) {
    // Saved search SO persists all filters as app filters
    services.data.query.filterManager.setAppFilters((0, _lodash.cloneDeep)(initialState.filters));
  }

  // some filters may not be valid for this context, so update
  // the filter manager with a modified list of valid filters
  const currentFilters = services.filterManager.getFilters();
  const validFilters = (0, _get_valid_filters.getValidFilters)(dataView, currentFilters);
  if (!(0, _lodash.isEqual)(currentFilters, validFilters)) {
    services.filterManager.setFilters(validFilters);
  }

  // set data service query
  if (initialState.query) {
    services.data.query.queryString.setQuery(initialState.query);
  }

  // Make sure global filters make it to the Discover session
  if (!urlState && shouldUpdateWithGlobalFilters) {
    discoverSession.searchSource.setField('filter', (0, _lodash.cloneDeep)(services.filterManager.getFilters()));
  }

  /**
   * Update state containers
   */

  if (persistedDiscoverSession) {
    // Set the persisted session first, then assign the
    // updated session to ensure unsaved changes are detected
    stateContainer.savedSearchState.set(persistedDiscoverSession);
    stateContainer.savedSearchState.assignNextSavedSearch(discoverSession);
  } else {
    stateContainer.savedSearchState.set(discoverSession);
  }

  // Make sure app state container is completely reset
  stateContainer.appState.resetToState(initialState);
  stateContainer.appState.resetInitialState();

  // Set runtime state
  stateContainer$.next(stateContainer);
  customizationService$.next(customizationService);

  // Begin syncing the state and trigger the initial fetch
  stateContainer.actions.initializeAndSync();
  stateContainer.actions.fetchData(true);
  discoverSessionLoadTracker.reportEvent();
  return {
    showNoDataPage: false
  };
};
exports.initializeSession = initializeSession;