"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRulesCountForPolicy = void 0;
var _constants = require("../../../common/constants");
var _helpers = require("../../../common/utils/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRulesCountForPolicy = async (soClient, benchmarkId) => {
  const rules = await soClient.find({
    type: _constants.CSP_BENCHMARK_RULE_SAVED_OBJECT_TYPE,
    filter: (0, _helpers.getBenchmarkFilter)(benchmarkId),
    perPage: 0
  });
  return rules.total;
};
exports.getRulesCountForPolicy = getRulesCountForPolicy;