"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.TruncatedCopyableText = exports.FindingsMisconfigurationFlyoutHeader = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _findings_flyout = require("../findings_flyout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TruncatedCopyableText = ({
  textToCopy
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    css: {
      paddingTop: '4px',
      overflow: 'hidden'
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: {
      float: 'left',
      overflow: 'hidden',
      whiteSpace: 'nowrap',
      textOverflow: 'ellipsis',
      maxWidth: 'calc(100% - 20px)',
      marginRight: '4px'
    }
  }, textToCopy), /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: textToCopy
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    css: (0, _react2.css)`
              :hover {
                cursor: pointer;
              }
            `,
    onClick: copy,
    type: "copy"
  })));
};
exports.TruncatedCopyableText = TruncatedCopyableText;
const FindingsMisconfigurationFlyoutHeader = ({
  finding
}) => {
  var _finding$rule, _finding$resource, _finding$observer, _finding$rule2, _finding$rule2$benchm, _finding$rule3, _finding$rule3$benchm;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const rulesTags = finding === null || finding === void 0 ? void 0 : (_finding$rule = finding.rule) === null || _finding$rule === void 0 ? void 0 : _finding$rule.tags;
  const resourceName = finding === null || finding === void 0 ? void 0 : (_finding$resource = finding.resource) === null || _finding$resource === void 0 ? void 0 : _finding$resource.name;
  const vendor = finding === null || finding === void 0 ? void 0 : (_finding$observer = finding.observer) === null || _finding$observer === void 0 ? void 0 : _finding$observer.vendor;
  const ruleBenchmarkId = finding === null || finding === void 0 ? void 0 : (_finding$rule2 = finding.rule) === null || _finding$rule2 === void 0 ? void 0 : (_finding$rule2$benchm = _finding$rule2.benchmark) === null || _finding$rule2$benchm === void 0 ? void 0 : _finding$rule2$benchm.id;
  const ruleBenchmarkName = finding === null || finding === void 0 ? void 0 : (_finding$rule3 = finding.rule) === null || _finding$rule3 === void 0 ? void 0 : (_finding$rule3$benchm = _finding$rule3.benchmark) === null || _finding$rule3$benchm === void 0 ? void 0 : _finding$rule3$benchm.name;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), rulesTags && rulesTags.map(tag => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    key: tag,
    color: 'hollow'
  }, tag)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    borderRadius: "none",
    paddingSize: "xl",
    css: {
      borderRight: 'solid 1px #D3DAE6',
      padding: '12px'
    },
    hasBorder: false,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("b", null, "Resource Name")), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: resourceName,
    position: "top"
  }, /*#__PURE__*/_react.default.createElement(TruncatedCopyableText, {
    textToCopy: resourceName
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    borderRadius: "none",
    paddingSize: "xl",
    css: {
      borderRight: 'solid 1px #D3DAE6',
      padding: '12px'
    },
    hasBorder: false,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("b", null, "Framework"), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), ruleBenchmarkId && ruleBenchmarkName && /*#__PURE__*/_react.default.createElement(_findings_flyout.BenchmarkIcons, {
    benchmarkId: ruleBenchmarkId,
    benchmarkName: ruleBenchmarkName,
    size: 'l'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    borderRadius: "none",
    paddingSize: "xl",
    css: {
      padding: '12px'
    },
    hasBorder: false,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("b", null, "Vendor")), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, " ", vendor, " ")))))))), /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
          margin: ${euiTheme.size.s};
        `
  }));
};

// eslint-disable-next-line import/no-default-export
exports.FindingsMisconfigurationFlyoutHeader = FindingsMisconfigurationFlyoutHeader;
var _default = exports.default = FindingsMisconfigurationFlyoutHeader;