"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartCollapse = void 0;
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _uuid = require("uuid");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _helpers = require("../../alerts_progress_bar_panel/helpers");
var _inspect = require("../../../../../common/components/inspect");
var _use_summary_chart_data = require("../../alerts_summary_charts_panel/use_summary_chart_data");
var _helpers2 = require("../../severity_level_panel/helpers");
var _formatted_number = require("../../../../../common/components/formatted_number");
var _helpers3 = require("./helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _risk_color_palette = require("../../../../../common/utils/risk_color_palette");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DETECTIONS_ALERTS_COLLAPSED_CHART_ID = 'detectioin-alerts-collapsed-chart';
const combinedAggregations = groupBySelection => {
  return {
    severities: {
      terms: {
        field: _ruleDataUtils.ALERT_SEVERITY,
        min_doc_count: 0
      }
    },
    topRule: {
      terms: {
        field: _ruleDataUtils.ALERT_RULE_NAME,
        size: 1
      }
    },
    topGrouping: {
      terms: {
        field: groupBySelection,
        size: 1
      }
    }
  };
};
const StyledEuiFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  margin-top: ${({
  theme
}) => theme.eui.euiSizeXS};
  @media only screen and (min-width: ${({
  theme
}) => theme.eui.euiBreakpoints.l}) {
  }
`;
const SeverityWrapper = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  min-width: 380px;
`;
const StyledEuiText = (0, _styledComponents.default)(_eui.EuiText)`
  border-left: 1px solid ${({
  theme
}) => theme.eui.euiColorLightShade};
  padding-left: ${({
  theme
}) => theme.eui.euiSizeL};
  // allows text to truncate
  max-width: 250px;
`;
const ChartCollapse = ({
  groupBySelection,
  filters,
  query,
  signalIndexName,
  runtimeMappings
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const uniqueQueryId = (0, _react.useMemo)(() => `${DETECTIONS_ALERTS_COLLAPSED_CHART_ID}-${(0, _uuid.v4)()}`, []);
  const aggregations = (0, _react.useMemo)(() => combinedAggregations(groupBySelection), [groupBySelection]);
  const {
    items,
    isLoading
  } = (0, _use_summary_chart_data.useSummaryChartData)({
    aggregations,
    filters,
    query,
    signalIndexName,
    runtimeMappings,
    uniqueQueryId
  });
  const data = (0, _react.useMemo)(() => (0, _helpers3.getIsChartCollapseData)(items) ? items : [], [items]);
  const topRule = (0, _react.useMemo)(() => {
    var _data$at$rule, _data$at;
    return (_data$at$rule = (_data$at = data.at(0)) === null || _data$at === void 0 ? void 0 : _data$at.rule) !== null && _data$at$rule !== void 0 ? _data$at$rule : i18n.NO_RESULT_MESSAGE;
  }, [data]);
  const topGroup = (0, _react.useMemo)(() => {
    var _data$at$group, _data$at2;
    return (_data$at$group = (_data$at2 = data.at(0)) === null || _data$at2 === void 0 ? void 0 : _data$at2.group) !== null && _data$at$group !== void 0 ? _data$at$group : i18n.NO_RESULT_MESSAGE;
  }, [data]);
  const severityColors = (0, _risk_color_palette.useRiskSeverityColors)();
  const severities = (0, _react.useMemo)(() => {
    var _data$at$severities, _data$at3;
    const severityData = (_data$at$severities = (_data$at3 = data.at(0)) === null || _data$at3 === void 0 ? void 0 : _data$at3.severities) !== null && _data$at$severities !== void 0 ? _data$at$severities : [];
    return Object.keys(severityColors).map(severity => {
      const obj = severityData.find(s => s.key === severity);
      if (obj) {
        return {
          key: obj.key,
          label: obj.label,
          value: obj.value
        };
      } else {
        return {
          key: severity,
          label: (0, _lodash.capitalize)(severity),
          value: 0
        };
      }
    });
  }, [data, severityColors]);
  const groupBy = (0, _react.useMemo)(() => (0, _helpers.getGroupByLabel)(groupBySelection), [groupBySelection]);
  return /*#__PURE__*/_react.default.createElement(_inspect.InspectButtonContainer, null, !isLoading && /*#__PURE__*/_react.default.createElement(StyledEuiFlexGroup, {
    alignItems: "center",
    "data-test-subj": "chart-collapse",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(SeverityWrapper, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "chart-collapse-severities"
  }, severities.map(severity => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: severity.key,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: (0, _helpers2.getSeverityColor)(severity.key, euiTheme)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, `${severity.label}: `, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
    count: severity.value || 0
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(StyledEuiText, {
    size: "xs",
    className: "eui-textTruncate",
    "data-test-subj": "chart-collapse-top-rule"
  }, /*#__PURE__*/_react.default.createElement("strong", null, i18n.TOP_RULE_TITLE), topRule)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(StyledEuiText, {
    size: "xs",
    className: "eui-textTruncate",
    "data-test-subj": "chart-collapse-top-group"
  }, /*#__PURE__*/_react.default.createElement("strong", null, `${i18n.TOP_GROUP_TITLE} ${groupBy}: `), topGroup)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_inspect.InspectButton, {
    isDisabled: false,
    queryId: uniqueQueryId,
    title: 'chart collapse'
  }))))));
};
exports.ChartCollapse = ChartCollapse;
ChartCollapse.displayName = 'ChartCollapse';