"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KqlQueryReadOnly = KqlQueryReadOnly;
var _react = _interopRequireDefault(require("react"));
var _detection_engine = require("../../../../../../../../../common/api/detection_engine");
var _inline_kql_query = require("./inline_kql_query");
var _saved_kql_query = require("./saved_kql_query");
var _utility_types = require("../../../../../../../../../common/utility_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function KqlQueryReadOnly({
  kqlQuery,
  dataSource,
  ruleType
}) {
  if (kqlQuery.type === _detection_engine.KqlQueryType.inline_query) {
    return /*#__PURE__*/_react.default.createElement(_inline_kql_query.InlineKqlQueryReadOnly, {
      kqlQuery: kqlQuery,
      dataSource: dataSource
    });
  }
  if (kqlQuery.type === _detection_engine.KqlQueryType.saved_query) {
    return /*#__PURE__*/_react.default.createElement(_saved_kql_query.SavedKqlQueryReadOnly, {
      kqlQuery: kqlQuery,
      dataSource: dataSource,
      ruleType: ruleType
    });
  }
  return (0, _utility_types.assertUnreachable)(kqlQuery);
}