"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShowingCountComponent = exports.ShowingCount = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ShowingContainer = _styledComponents.default.div`
  user-select: none;
  margin-top: 5px;
`;
ShowingContainer.displayName = 'ShowingContainer';
const ShowingCountComponent = ({
  filterResultsLength
}) => /*#__PURE__*/_react.default.createElement(ShowingContainer, {
  "data-test-subj": "showing"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: "subdued",
  size: "xs"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  "data-test-subj": "query-message",
  id: "xpack.securitySolution.components.mlPopup.showingLabel",
  defaultMessage: "Showing: {filterResultsLength} {filterResultsLength, plural, one {job} other {jobs}}",
  values: {
    filterResultsLength
  }
})));
exports.ShowingCountComponent = ShowingCountComponent;
ShowingCountComponent.displayName = 'ShowingCountComponent';
const ShowingCount = exports.ShowingCount = /*#__PURE__*/_react.default.memo(ShowingCountComponent);
ShowingCount.displayName = 'ShowingCount';