"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LastUpdatedAt = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UPDATING = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.updating', {
  defaultMessage: 'Updating...'
});
const UPDATED = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.updated', {
  defaultMessage: 'Updated'
});
const LastUpdatedAt = ({
  isUpdating,
  updatedAt
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, isUpdating ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, UPDATING) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, UPDATED, " "), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
  "data-test-subj": "last-updated-at-date",
  value: new Date(updatedAt)
})));
exports.LastUpdatedAt = LastUpdatedAt;