"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HealthTruncateText = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StatusTextWrapper = _styledComponents.default.div`
  width: 100%;
  display: inline-grid;
`;
/**
 * Allows text in EuiHealth to be properly truncated with tooltip
 * @param healthColor - color for EuiHealth component
 * @param tooltipContent - tooltip content
 */
const HealthTruncateText = ({
  tooltipContent,
  children,
  healthColor,
  dataTestSubj
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: tooltipContent
}, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
  color: healthColor,
  "data-test-subj": dataTestSubj
}, /*#__PURE__*/_react.default.createElement(StatusTextWrapper, {
  tabIndex: 0
}, /*#__PURE__*/_react.default.createElement("span", {
  className: "eui-textTruncate"
}, children))));
exports.HealthTruncateText = HealthTruncateText;
HealthTruncateText.displayName = 'HealthTruncateText';