"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EntityType", {
  enumerable: true,
  get: function () {
    return _types.EntityType;
  }
});
exports.getRiskIndex = exports.buildUserNamesFilter = exports.buildHostNamesFilter = exports.buildEntityNameFilter = void 0;
var _types = require("../../../../entity_analytics/types");
var _risk_engine = require("../../../../entity_analytics/risk_engine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRiskIndex = (spaceId, onlyLatest = true) => {
  return onlyLatest ? (0, _risk_engine.getRiskScoreLatestIndex)(spaceId) : (0, _risk_engine.getRiskScoreTimeSeriesIndex)(spaceId);
};
exports.getRiskIndex = getRiskIndex;
const buildHostNamesFilter = hostNames => {
  return buildEntityNameFilter(_types.EntityType.host, hostNames);
};
exports.buildHostNamesFilter = buildHostNamesFilter;
const buildUserNamesFilter = userNames => {
  return buildEntityNameFilter(_types.EntityType.user, userNames);
};
exports.buildUserNamesFilter = buildUserNamesFilter;
const buildEntityNameFilter = (riskEntity, entityNames) => {
  return {
    terms: {
      [_types.EntityTypeToIdentifierField[riskEntity]]: entityNames
    }
  };
};
exports.buildEntityNameFilter = buildEntityNameFilter;