"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RollupPlugin = void 0;
var _i18n = require("@kbn/i18n");
var _extend_index_management = require("./extend_index_management");
var _common = require("../common");
var _services = require("./crud_app/services");
var _kibana_services = require("./kibana_services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class RollupPlugin {
  constructor(ctx) {
    this.ctx = ctx;
  }
  setup(core, {
    home,
    management,
    indexManagement,
    usageCollection,
    dataViews
  }) {
    const {
      ui: {
        enabled: isRollupUiEnabled
      }
    } = this.ctx.config.get();
    (0, _kibana_services.setFatalErrors)(core.fatalErrors);
    if (usageCollection) {
      (0, _kibana_services.setUiStatsReporter)(usageCollection.reportUiCounter.bind(usageCollection, _common.UIM_APP_NAME));
    }
    if (isRollupUiEnabled) {
      if (indexManagement) {
        indexManagement.extensionsService.addBadge(_extend_index_management.rollupBadgeExtension);
        indexManagement.extensionsService.addToggle(_extend_index_management.rollupToggleExtension);
      }
      if (home) {
        home.featureCatalogue.register({
          id: 'rollup_jobs',
          title: 'Rollups',
          description: _i18n.i18n.translate('xpack.rollupJobs.featureCatalogueDescription', {
            defaultMessage: 'Summarize and store historical data in a smaller index for future analysis.'
          }),
          icon: 'indexRollupApp',
          path: `/app/management/data/rollup_jobs/job_list`,
          showOnHomePage: false,
          category: 'admin'
        });
      }
      dataViews.enableRollups();
      const pluginName = _i18n.i18n.translate('xpack.rollupJobs.appTitle', {
        defaultMessage: 'Rollup Jobs'
      });
      management.sections.section.data.registerApp({
        id: 'rollup_jobs',
        title: pluginName,
        order: 4,
        async mount(params) {
          const [coreStart] = await core.getStartServices();
          const {
            chrome: {
              docTitle
            }
          } = coreStart;
          docTitle.change(pluginName);
          params.setBreadcrumbs([{
            text: pluginName
          }]);
          const {
            renderApp
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
          const unmountAppCallback = await renderApp(core, params);
          return () => {
            docTitle.reset();
            unmountAppCallback();
          };
        }
      });
    }
  }
  start(core) {
    (0, _services.setHttp)(core.http);
    (0, _kibana_services.setNotifications)(core.notifications);
    (0, _services.init)(core.docLinks);
  }
}
exports.RollupPlugin = RollupPlugin;