"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DifferentialComparisonMode = DifferentialComparisonMode;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _normalization_menu = require("../normalization_menu");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DifferentialComparisonMode({
  comparisonMode,
  onChange
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.profiling.differentialComparisonMode.title', {
    defaultMessage: 'Format'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('xpack.profiling.differentialComparisonMode.legend', {
      defaultMessage: 'This switch allows you to switch between an absolute and relative comparison between both graphs'
    }),
    type: "single",
    buttonSize: "s",
    idSelected: comparisonMode,
    onChange: nextComparisonMode => {
      onChange(nextComparisonMode);
    },
    options: [{
      id: _normalization_menu.ComparisonMode.Absolute,
      label: _i18n.i18n.translate('xpack.profiling.differentialComparisonMode.absoluteButtonLabel', {
        defaultMessage: 'Abs'
      })
    }, {
      id: _normalization_menu.ComparisonMode.Relative,
      label: _i18n.i18n.translate('xpack.profiling.differentialComparisonMode.relativeButtonLabel', {
        defaultMessage: 'Rel'
      })
    }]
  }))));
}