"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.naturalLanguageSearchTool = void 0;
var _zod = require("@kbn/zod");
var _onechatCommon = require("@kbn/onechat-common");
var _onechatGenaiUtils = require("@kbn/onechat-genai-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const searchDslSchema = _zod.z.object({
  query: _zod.z.string().describe('A natural language query expressing the search request'),
  index: _zod.z.string().optional().describe('(optional) Index to search against. If not provided, will use the index explorer to find the best index to use.'),
  context: _zod.z.string().optional().describe('(optional) Additional context that could be useful to perform the search')
});
const naturalLanguageSearchTool = () => {
  return {
    id: _onechatCommon.BuiltinToolIds.naturalLanguageSearch,
    description: 'Run a DSL search query on one index and return matching documents.',
    schema: searchDslSchema,
    handler: async ({
      query,
      index,
      context
    }, {
      esClient,
      modelProvider
    }) => {
      const model = await modelProvider.getDefaultModel();
      return (0, _onechatGenaiUtils.naturalLanguageSearch)({
        query,
        context,
        index,
        model,
        esClient: esClient.asCurrentUser
      });
    },
    meta: {
      tags: [_onechatCommon.BuiltinTags.retrieval]
    }
  };
};
exports.naturalLanguageSearchTool = naturalLanguageSearchTool;