"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addRoundCompleteEvent = void 0;
var _rxjs = require("rxjs");
var _onechatCommon = require("@kbn/onechat-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isStepEvent = event => {
  return (0, _onechatCommon.isReasoningEvent)(event) || (0, _onechatCommon.isToolCallEvent)(event);
};
const addRoundCompleteEvent = ({
  userInput
}) => {
  return events$ => {
    const shared$ = events$.pipe((0, _rxjs.share)());
    return (0, _rxjs.merge)(shared$, shared$.pipe((0, _rxjs.toArray)(), (0, _rxjs.map)(events => {
      const round = createRoundFromEvents({
        events,
        userInput
      });
      const event = {
        type: _onechatCommon.ChatAgentEventType.roundComplete,
        data: {
          round
        }
      };
      return event;
    })));
  };
};
exports.addRoundCompleteEvent = addRoundCompleteEvent;
const createRoundFromEvents = ({
  events,
  userInput
}) => {
  const toolResults = events.filter(_onechatCommon.isToolResultEvent).map(event => event.data);
  const messages = events.filter(_onechatCommon.isMessageCompleteEvent).map(event => event.data);
  const stepEvents = events.filter(isStepEvent);
  const eventToStep = event => {
    if ((0, _onechatCommon.isToolCallEvent)(event)) {
      var _toolResult$result;
      const toolCall = event.data;
      const toolResult = toolResults.find(result => result.toolCallId === toolCall.toolCallId);
      return {
        type: _onechatCommon.ConversationRoundStepType.toolCall,
        toolCallId: toolCall.toolCallId,
        toolId: toolCall.toolId,
        args: toolCall.args,
        result: (_toolResult$result = toolResult === null || toolResult === void 0 ? void 0 : toolResult.result) !== null && _toolResult$result !== void 0 ? _toolResult$result : 'unknown'
      };
    }
    if ((0, _onechatCommon.isReasoningEvent)(event)) {
      return {
        type: _onechatCommon.ConversationRoundStepType.reasoning,
        reasoning: event.data.reasoning
      };
    }
    throw new Error(`Unknown event type: ${event.type}`);
  };
  const round = {
    userInput,
    steps: stepEvents.map(eventToStep),
    assistantResponse: {
      message: messages[messages.length - 1].messageContent
    }
  };
  return round;
};