"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogRateAnalysisEQQuery = void 0;
var _lodash = require("lodash");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _get_group = require("../../../../../../common/custom_threshold_rule/helpers/get_group");
var _types = require("../../../../../../common/custom_threshold_rule/types");
var _build_es_query = require("../../../../../utils/build_es_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getKuery = (metrics, filter) => {
  let query = '';
  const isOneCountConditionWithFilter = metrics.length === 1 && metrics[0].aggType === 'count' && metrics[0].filter;
  if (filter && isOneCountConditionWithFilter) {
    query = `(${filter}) and (${metrics[0].filter})`;
  } else if (isOneCountConditionWithFilter) {
    query = `(${metrics[0].filter})`;
  } else if (filter) {
    query = `(${filter})`;
  }
  return query;
};
const getLogRateAnalysisEQQuery = (alert, config) => {
  const ruleParams = alert.fields[_ruleDataUtils.ALERT_RULE_PARAMETERS];
  // We only show log rate analysis for one condition with one count aggregation
  if (ruleParams.criteria.length !== 1 || ruleParams.criteria[0].metrics.length !== 1 || ruleParams.criteria[0].metrics[0].aggType !== _types.Aggregators.COUNT) {
    return;
  }
  const group = (0, _lodash.get)(alert, 'fields["kibana.alert.group"]');
  const optionalFilter = (0, _lodash.get)(ruleParams.searchConfiguration, 'query.query');
  const groupByFilters = (0, _get_group.getGroupFilters)(group);
  const boolQuery = (0, _build_es_query.buildEsQuery)({
    kuery: getKuery(ruleParams.criteria[0].metrics, optionalFilter),
    filters: groupByFilters,
    config
  });
  return boolQuery;
};
exports.getLogRateAnalysisEQQuery = getLogRateAnalysisEQQuery;