"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_WORKER_ID = void 0;
var _languages = require("./languages");
var _monaco_imports = require("./monaco_imports");
var _kbnPublicPath__;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const DEFAULT_WORKER_ID = exports.DEFAULT_WORKER_ID = 'default';
const langSpecificWorkerIds = [_monaco_imports.monaco.languages.json.jsonDefaults.languageId, _languages.XJSON_LANG_ID, _languages.PAINLESS_LANG_ID, _languages.YAML_LANG_ID, _languages.CONSOLE_LANG_ID];

// exported for use in webpack config to build workers

const monacoBundleDir = (_kbnPublicPath__ = window.__kbnPublicPath__) === null || _kbnPublicPath__ === void 0 ? void 0 : _kbnPublicPath__['kbn-monaco'];
window.MonacoEnvironment = {
  // passed for use in functional and unit tests so that we can verify values from 'editor'
  monaco: _monaco_imports.monaco,
  getWorkerUrl: monacoBundleDir ? (_, languageId) => {
    const workerId = langSpecificWorkerIds.includes(languageId) ? languageId : DEFAULT_WORKER_ID;
    return `${monacoBundleDir}${workerId}.editor.worker.js`;
  } : () => ''
};