"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyDetectionInfoButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _mlUrlState = require("@kbn/ml-url-state");
var _locator = require("../../../../../common/constants/locator");
var _job_details_flyout = require("../../../jobs/components/job_details_flyout");
var _kibana = require("../../../contexts/kibana");
var _get_options_for_job_selector_menu = require("../group_or_job_selector_menu/get_options_for_job_selector_menu");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnomalyDetectionInfoButton = ({
  jobId,
  page,
  onRemoveJobId,
  removeJobIdDisabled,
  isSingleMetricViewerDisabled
}) => {
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const {
    services: {
      share,
      application: {
        navigateToUrl
      }
    }
  } = (0, _kibana.useMlKibana)();
  const [globalState] = (0, _mlUrlState.useUrlState)('_g');
  const popoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'adJobInfoContextMenu',
    suffix: jobId
  });
  const onButtonClick = () => {
    setPopover(!isPopoverOpen);
  };
  const closePopover = () => {
    setPopover(false);
  };
  const {
    setActiveFlyout,
    setActiveJobId
  } = (0, _job_details_flyout.useJobInfoFlyouts)();
  const panels = (0, _react.useMemo)(() => {
    return [{
      id: 0,
      items: (0, _get_options_for_job_selector_menu.getOptionsForJobSelectorMenuItems)({
        jobId,
        page,
        onRemoveJobId,
        removeJobIdDisabled,
        showRemoveJobId: page === _locator.ML_PAGES.ANOMALY_EXPLORER,
        isSingleMetricViewerDisabled,
        closePopover,
        globalState,
        setActiveFlyout,
        setActiveJobId,
        navigateToUrl,
        share
      })
    }];
  },
  // globalState is an object with references change on every render, so we are stringifying it here
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [jobId, page, setActiveJobId, setActiveFlyout, navigateToUrl, share.url.locators, removeJobIdDisabled, onRemoveJobId,
  // eslint-disable-next-line react-hooks/exhaustive-deps
  JSON.stringify(globalState)]);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "mlJobSelectionBadge",
    iconType: "boxesVertical",
    iconSide: "right",
    onClick: onButtonClick,
    size: "s",
    color: "text"
  }, jobId);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: popoverId,
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels
  }));
};
exports.AnomalyDetectionInfoButton = AnomalyDetectionInfoButton;