"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomTimeRangePicker = void 0;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../contexts/kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * React component for the form for adding a custom time range.
 */
const CustomTimeRangePicker = ({
  onCustomTimeRangeChange,
  customTimeRange,
  disabled
}) => {
  const [showCustomTimeRangeSelector, setShowCustomTimeRangeSelector] = (0, _react.useState)(false);
  const {
    services: {
      data: {
        query: {
          timefilter: {
            timefilter
          }
        }
      }
    }
  } = (0, _kibana.useMlKibana)();

  // If the custom time range is not set, default to the timefilter settings
  const currentTimeRange = (0, _react.useMemo)(() => customTimeRange !== null && customTimeRange !== void 0 ? customTimeRange : {
    start: (0, _moment.default)(timefilter.getAbsoluteTime().from),
    end: (0, _moment.default)(timefilter.getAbsoluteTime().to)
  }, [customTimeRange, timefilter]);
  const onCustomTimeRangeSwitchChange = checked => {
    if (checked === false) {
      // Clear the custom time range so it isn't persisted
      onCustomTimeRangeChange(undefined);
    } else {
      onCustomTimeRangeChange(currentTimeRange);
    }
    setShowCustomTimeRangeSelector(checked);
  };
  const handleStartChange = date => {
    onCustomTimeRangeChange({
      ...currentTimeRange,
      start: date
    });
  };
  const handleEndChange = date => {
    onCustomTimeRangeChange({
      ...currentTimeRange,
      end: date
    });
  };
  const {
    start,
    end
  } = currentTimeRange;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    disabled: disabled,
    label: _i18n.i18n.translate('xpack.ml.customUrlsEditor.addCustomTimeRangeSwitchLabel', {
      defaultMessage: 'Add custom time range'
    }),
    checked: showCustomTimeRangeSelector,
    onChange: e => onCustomTimeRangeSwitchChange(e.target.checked)
  }), showCustomTimeRangeSelector ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.customUrlsEditor.customTimeRangeLabel",
      defaultMessage: "Custom time range"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDatePickerRange, {
    "data-test-subj": `mlCustomUrlsDateRange`,
    isInvalid: start > end,
    startDateControl: /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
      selected: start,
      onChange: handleStartChange,
      startDate: start,
      endDate: end,
      "aria-label": _i18n.i18n.translate('xpack.ml.customUrlsEditor.customTimeRangeStartDate', {
        defaultMessage: 'Start date'
      }),
      showTimeSelect: true
    }),
    endDateControl: /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
      selected: end,
      onChange: handleEndChange,
      startDate: start,
      endDate: end,
      "aria-label": _i18n.i18n.translate('xpack.ml.customUrlsEditor.customTimeRangeEndDate', {
        defaultMessage: 'End date'
      }),
      showTimeSelect: true
    })
  }))) : null);
};
exports.CustomTimeRangePicker = CustomTimeRangePicker;