"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VectorStyleSymbolizeAsEditor = VectorStyleSymbolizeAsEditor;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../../common/constants");
var _get_vector_style_label = require("../get_vector_style_label");
var _disabled_tooltip = require("../../disabled_tooltip");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SYMBOLIZE_AS_OPTIONS = [{
  id: _constants.SYMBOLIZE_AS_TYPES.CIRCLE,
  label: _i18n.i18n.translate('xpack.maps.vector.symbolAs.circleLabel', {
    defaultMessage: 'marker'
  })
}, {
  id: _constants.SYMBOLIZE_AS_TYPES.ICON,
  label: _i18n.i18n.translate('xpack.maps.vector.symbolAs.IconLabel', {
    defaultMessage: 'icon'
  })
}];
function VectorStyleSymbolizeAsEditor({
  disabled,
  disabledBy,
  styleProperty,
  handlePropertyChange
}) {
  const styleOptions = styleProperty.getOptions();
  const selectedOption = SYMBOLIZE_AS_OPTIONS.find(({
    id
  }) => {
    return id === styleOptions.value;
  });
  const onSymbolizeAsChange = optionId => {
    const styleDescriptor = {
      options: {
        value: optionId
      }
    };
    handlePropertyChange(_constants.VECTOR_STYLES.SYMBOLIZE_AS, styleDescriptor);
  };
  const symbolLabel = _i18n.i18n.translate('xpack.maps.vector.symbolLabel', {
    defaultMessage: 'Symbol type'
  });
  const symbolizeAsForm = /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: symbolLabel,
    display: "columnCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isDisabled: disabled,
    buttonSize: "compressed",
    options: SYMBOLIZE_AS_OPTIONS,
    idSelected: selectedOption ? selectedOption.id : undefined,
    onChange: onSymbolizeAsChange,
    isFullWidth: true,
    legend: symbolLabel
  }));
  if (!disabled) {
    return symbolizeAsForm;
  }
  return /*#__PURE__*/_react.default.createElement(_disabled_tooltip.DisabledToolTip, {
    content: (0, _get_vector_style_label.getDisabledByMessage)(disabledBy)
  }, symbolizeAsForm);
}