"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ModeSwitcher = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ModeSwitcher = ({
  onSave,
  onEditCancel,
  onEdit,
  onAdd,
  mode,
  customMetrics,
  disableAdd = false
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (['editMetric', 'addMetric'].includes(mode)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      borderTop: `${euiTheme.border.thin} solid ${euiTheme.border.color}`,
      padding: 12
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, mode === 'edit' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "infraModeSwitcherCancelButton",
    size: "s",
    flush: "left",
    onClick: onEditCancel,
    "aria-label": _i18n.i18n.translate('xpack.infra.waffle.customMetrics.modeSwitcher.cancelAriaLabel', {
      defaultMessage: 'Cancel edit mode'
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.waffle.customMetrics.modeSwitcher.cancel",
    defaultMessage: "Cancel"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraModeSwitcherSaveButton",
    onClick: onSave,
    size: "s",
    fill: true,
    "aria-label": _i18n.i18n.translate('xpack.infra.waffle.customMetrics.modeSwitcher.saveButtonAriaLabel', {
      defaultMessage: 'Save changes to custom metrics'
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.waffle.customMetrics.modeSwitcher.saveButton",
    defaultMessage: "Save"
  })))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "infraModeSwitcherEditButton",
    size: "s",
    flush: "left",
    onClick: onEdit,
    disabled: customMetrics.length === 0,
    "aria-label": _i18n.i18n.translate('xpack.infra.waffle.customMetrics.modeSwitcher.editAriaLabel', {
      defaultMessage: 'Edit custom metrics'
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.waffle.customMetrics.modeSwitcher.edit",
    defaultMessage: "Edit"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: disableAdd ? _i18n.i18n.translate('xpack.infra.waffle.customMetrics.modeSwitcher.addDisabledTooltip', {
      defaultMessage: 'Maximum number of {maxMetrics} metrics reached.',
      values: {
        maxMetrics: _constants.SNAPSHOT_API_MAX_METRICS
      }
    }) : undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "infraModeSwitcherAddMetricButton",
    onClick: onAdd,
    disabled: disableAdd,
    size: "s",
    flush: "right",
    "aria-label": _i18n.i18n.translate('xpack.infra.waffle.customMetrics.modeSwitcher.addMetricAriaLabel', {
      defaultMessage: 'Add custom metric'
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.waffle.customMetrics.modeSwitcher.addMetric",
    defaultMessage: "Add metric"
  })))))));
};
exports.ModeSwitcher = ModeSwitcher;