"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.promptToMessageOptions = promptToMessageOptions;
var _inferenceCommon = require("@kbn/inference-common");
var _lodash = require("lodash");
var _mustache = _interopRequireDefault(require("mustache"));
var _util = require("util");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var MatchType = /*#__PURE__*/function (MatchType) {
  MatchType[MatchType["default"] = 0] = "default";
  MatchType[MatchType["modelFamily"] = 1] = "modelFamily";
  MatchType[MatchType["modelId"] = 2] = "modelId";
  return MatchType;
}(MatchType || {});
function promptToMessageOptions(prompt, input, model) {
  const matches = prompt.versions.flatMap(version => {
    if (!version.models) {
      return [{
        version,
        match: MatchType.default
      }];
    }
    return version.models.flatMap(match => {
      if (match.id) {
        var _model$id;
        return (_model$id = model.id) !== null && _model$id !== void 0 && _model$id.includes(match.id) ? [{
          version,
          match: MatchType.modelId
        }] : [];
      }
      return match.family === model.family ? [{
        version,
        match: MatchType.modelFamily
      }] : [];
    });
  });
  const bestMatch = (0, _lodash.orderBy)(matches, match => match.match, 'desc')[0].version;
  if (!bestMatch) {
    throw new Error(`No model match found for ${(0, _util.format)(model)}`);
  }
  const {
    toolChoice,
    tools,
    temperature,
    template
  } = bestMatch;
  const validatedInput = prompt.input.parse(input);
  const messages = 'chat' in template ? template.chat.messages : [{
    role: _inferenceCommon.MessageRole.User,
    content: 'mustache' in template ? _mustache.default.render(template.mustache.template, validatedInput) : template.static.content
  }];
  const system = !bestMatch.system || typeof bestMatch.system === 'string' ? bestMatch.system : _mustache.default.render(bestMatch.system.mustache.template, validatedInput);
  return {
    match: bestMatch,
    options: (0, _lodash.omitBy)({
      messages,
      system,
      tools,
      toolChoice,
      temperature
    }, val => val === undefined)
  };
}