"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailsPageMappings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/es-ui-shared-plugin/public");
var _details_page_mappings_content = require("./details_page_mappings_content");
var _services = require("../../../../services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DetailsPageMappings = ({
  index,
  showAboutMappings = true,
  hasUpdateMappingsPrivilege
}) => {
  const {
    isLoading,
    data,
    error,
    resendRequest
  } = (0, _services.useLoadIndexMappings)((index === null || index === void 0 ? void 0 : index.name) || '');
  const [jsonError, setJsonError] = (0, _react.useState)(false);
  const stringifiedData = (0, _react.useMemo)(() => {
    if (data) {
      try {
        setJsonError(false);
        return JSON.stringify(data, null, 2);
      } catch (e) {
        setJsonError(true);
      }
    }
  }, [data]);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_public.SectionLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.mappings.loadingDescription",
      defaultMessage: "Loading index mappings\u2026"
    }));
  }
  if (error || jsonError || !stringifiedData || !(index !== null && index !== void 0 && index.name)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      "data-test-subj": "indexDetailsMappingsError",
      color: "danger",
      iconType: "warning",
      title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexDetails.mappings.errorTitle",
        defaultMessage: "Unable to load index mappings"
      })),
      body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexDetails.mappings.errorDescription",
        defaultMessage: "We encountered an error loading mappings for index {indexName}. Make sure that the index name in the URL is correct and try again.",
        values: {
          indexName: (index === null || index === void 0 ? void 0 : index.name) || undefined
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        iconSide: "right",
        onClick: resendRequest,
        iconType: "refresh",
        color: "danger",
        "data-test-subj": "indexDetailsMappingsReloadButton"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexDetails.mappings.reloadButtonLabel",
        defaultMessage: "Reload"
      })))
    });
  }
  return /*#__PURE__*/_react.default.createElement(_details_page_mappings_content.DetailsPageMappingsContent, {
    index: index,
    data: stringifiedData,
    jsonData: data,
    showAboutMappings: showAboutMappings,
    refetchMapping: resendRequest,
    hasUpdateMappingsPrivilege: hasUpdateMappingsPrivilege
  });
};
exports.DetailsPageMappings = DetailsPageMappings;