"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GrokdebuggerRequest = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class GrokdebuggerRequest {
  constructor(props = {}) {
    this.rawEvent = (0, _lodash.get)(props, 'rawEvent', '');
    this.pattern = (0, _lodash.get)(props, 'pattern', '');
    this.customPatterns = (0, _lodash.get)(props, 'customPatterns', {});
  }
  get upstreamJSON() {
    return (0, _lodash.pick)(this, ['rawEvent', 'pattern', 'customPatterns']);
  }
}
exports.GrokdebuggerRequest = GrokdebuggerRequest;