"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.noUserSelectStyles = exports.gphSidebarPanelStyles = exports.gphSidebarHeaderStyles = exports.gphFieldBadgeSizeStyles = void 0;
var _react = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const gphFieldBadgeSizeStyles = ({
  euiTheme
}) => (0, _react.css)({
  height: euiTheme.size.l,
  // Subtract 2 for the border
  lineHeight: `calc(${euiTheme.size.l} - 2px)`
});
exports.gphFieldBadgeSizeStyles = gphFieldBadgeSizeStyles;
const gphSidebarHeaderStyles = ({
  euiTheme
}) => (0, _react.css)({
  marginTop: euiTheme.size.s,
  color: euiTheme.colors.emptyShade,
  backgroundColor: euiTheme.colors.darkestShade,
  padding: euiTheme.size.xs,
  borderRadius: euiTheme.border.radius.medium,
  marginBottom: euiTheme.size.xs
});
exports.gphSidebarHeaderStyles = gphSidebarHeaderStyles;
const gphSidebarPanelStyles = ({
  euiTheme
}) => (0, _react.css)({
  maxHeight: `calc(${euiTheme.size.l} * 10)`,
  // Invalid property hidden auto;
  overflowY: 'hidden'
});
exports.gphSidebarPanelStyles = gphSidebarPanelStyles;
const noUserSelectStyles = exports.noUserSelectStyles = (0, _react.css)({
  userSelect: 'none',
  // Invalid property value: https://developer.mozilla.org/en-US/docs/Web/CSS/-webkit-touch-callout
  WebkitTouchCallout: 'none',
  WebkitTapHighlightColor: 'transparent'
});