"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useChangelog = void 0;
var _react = require("react");
var _hooks = require("../../../../../hooks");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * @param packageName the package to get the changelog for
 * @param latestVersion the version of changelog for the specified package
 * @param currentVersion is used to display the changelog starting from this version up to the latest version
 */
const useChangelog = (packageName, latestVersion, currentVersion) => {
  const {
    data,
    error: getFileError,
    isLoading
  } = (0, _hooks.useGetFileByPathQuery)(`/package/${packageName}/${latestVersion}/changelog.yml`);
  const error = (getFileError === null || getFileError === void 0 ? void 0 : getFileError.statusCode) === 404 ? null : getFileError;
  const changelog = (0, _react.useMemo)(() => {
    return (0, _utils.parseYamlChangelog)(data, latestVersion, currentVersion);
  }, [data, latestVersion, currentVersion]);
  const breakingChanges = (0, _react.useMemo)(() => {
    const _breakingChanges = (0, _utils.getBreakingChanges)(changelog);
    return _breakingChanges.length > 0 ? _breakingChanges : null;
  }, [changelog]);
  return {
    changelog,
    breakingChanges,
    error,
    isLoading
  };
};
exports.useChangelog = useChangelog;